/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.entity.ShopAddress;
import com.tcbj.crm.entity.ShopContacts;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopExcelVaildateService;
import com.tcbj.crm.shop.ShopReportCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/shop"})
public class ShopController
extends BaseController {
    @Autowired
    private ShopService service;
    @Autowired
    private Cache cach;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    ShopExcelVaildateService excelVaildateService;
    @Autowired
    private PersonnelService personnelService;
    static Map<String, String> errorMap = new LinkedHashMap<String, String>();

    @RequestMapping(value={"/myapplys.do"})
    public String myapplys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        this.getCurrentEmployee();
        model.addAttribute("condition", (Object)con);
        return this.findApplys(pageno, con, model);
    }

    private String findApplys(int pageno, ShopCondition condition, Model model) {
        Employee e = this.getCurrentEmployee();
        Page applys = this.service.findShopApplys(condition, e, pageno);
        model.addAttribute("startDate", (Object)DateUtils.now());
        model.addAttribute("shopApplys", (Object)applys);
        model.addAttribute("me", (Object)e);
        model.addAttribute((Object)condition);
        return "shop/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Shop shop = null;
        if (StringUtils.isEmpty(id)) {
            shop = new Shop();
            shop.initialize();
            shop.setShopNumber(this.orderNoService.updateShopNo("200001", false));
        } else {
            shop = this.service.getShopById(id);
        }
        shop.fillInitData(me);
        this.getCurrentSalesman(model, me.getCurrentPartner().getId(), shop.getSalseManId());
        model.addAttribute("me", (Object)me);
        model.addAttribute("shop", (Object)shop);
        model.addAttribute("date", (Object)DateUtils.now());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shop.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shop.getContactses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "shop/apply.ftl";
    }

    private void getCurrentSalesman(Model model, String salseManId, String partnerId) {
        PartnerContact salseMan = this.service.getCurentSaleMan(partnerId, salseManId);
        model.addAttribute("salseMan", (Object)salseMan);
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody Shop shop, String type, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        boolean flag = this.service.validateShopViewName(me, shop.getShopName(), shop.getAddressDetails());
        if (!flag) {
            throw new AppException("8005", shop.getShopName());
        }
        boolean flag2 = this.service.validateCilentNo(me, shop.getOuterClientNo().trim());
        if (!flag2) {
            throw new AppException("8006", shop.getOuterClientNo());
        }
        shop.setShopNumber(this.orderNoService.updateShopNo("200001", true));
        shop.fillInitData(me);
        shop.setApproveState(type);
        shop.setApplyType(ShopEnum.ApplyType.add.getValue());
        this.saveOrUpdateShop(shop, me);
        return this.getSuccessResult(null);
    }

    private void saveOrUpdateShop(Shop shop, Employee me) {
        for (ShopAddress address : shop.getAddresses()) {
            address.setSiebelAddressId(address.getId());
            address.getContatsPhone();
            address.fillInitData(me);
        }
        for (ShopContacts contact : shop.getContactses()) {
            contact.setSiebelContactsId(contact.getId());
            contact.fillInitData(me);
        }
        if (StringUtils.isEmpty(shop.getId())) {
            this.service.add(shop, me);
        } else {
            this.service.update(shop, me);
        }
    }

    @RequestMapping(value={"/del"})
    @ResponseBody
    public Result del(String id, Model model) {
        this.service.del(id);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Shop shop = this.service.getShopById(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("shop", (Object)shop);
        this.getSalesName(model, shop.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shop.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shop.getContactses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "shop/view.ftl";
    }

    @RequestMapping(value={"/audits.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String audits(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        if (!"dealing".equals(con.getAuditType()) && !"dealed".equals(con.getAuditType())) {
            throw new AppException("8001");
        }
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        Page audits = this.service.findShopAudits(con, pageno, me);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("me", (Object)me);
        model.addAttribute("audits", (Object)audits);
        return "shop/audits.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Shop shop = this.service.getShopById(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("shop", (Object)shop);
        this.getSalesName(model, shop.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shop.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shop.getContactses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "shop/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(String id, String approveState, String opinion, String applyType, Model model) {
        if (!approveState.equals(ShopEnum.ApproveState.pass.getValue()) && !approveState.equals(ShopEnum.ApproveState.notpass.getValue())) {
            approveState = ShopEnum.ApproveState.notpass.getValue();
        }
        if (ShopEnum.ApplyType.add.getValue().equals(applyType)) {
            applyType = "insert";
        } else if (ShopEnum.ApplyType.edit.getValue().equals(applyType)) {
            applyType = "update";
        } else {
            throw new AppException("8002");
        }
        Employee me = this.getCurrentEmployee();
        this.service.saveAudit(id, approveState, me, opinion, applyType);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/findShopViews.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findShopViews(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isEmpty(me.getCurrentPartner().getParPartnerId())) {
            con.setIsOrg(true);
        } else {
            con.setIsOrg(false);
        }
        con.setPartnerId(me.getCurrentPartner().getId());
        Page shopViews = this.service.findShopViews(con, me, pageno);
        model.addAttribute("shopViews", (Object)shopViews);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "shop/finds.ftl";
    }

    @RequestMapping(value={"/viewShopView.do"}, method={RequestMethod.GET})
    public String viewPartner(@RequestParam(value="id", required=true) String id, Model model) {
        ShopView shopView = this.service.getShopView(id);
        model.addAttribute("shop", (Object)shopView);
        this.getSalesName(model, shopView.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shopView.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shopView.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("hideaudit", (Object)"true");
        return "shop/view.ftl";
    }

    @RequestMapping(value={"/editShopView.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        ShopView shopView = this.service.getShopView(id);
        Employee me = this.getCurrentEmployee();
        this.getCurrentSalesman(model, me.getCurrentPartner().getId(), shopView.getSalseManId());
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(shopView.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(shopView.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("shop", (Object)shopView);
        model.addAttribute("currentParnertName", (Object)Cache.getPartnerName(shopView.getParentDealerId()));
        return "shop/edit.ftl";
    }

    @RequestMapping(value={"/editShopView.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody Shop shop, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        boolean flag = this.service.validateSiebleShopName(shop.getParentDealerId(), shop.getId(), shop.getShopName());
        if (!flag) {
            throw new AppException("8005", shop.getShopName());
        }
        shop.getDelIds();
        shop.fillInitData(me);
        shop.setApplyType(ShopEnum.ApplyType.edit.getValue());
        shop.setApproveState(ShopEnum.ApproveState.audit.getValue());
        shop.setSiebelShopId(shop.getId());
        this.service.add(shop, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/findRecords.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findRecords(String id, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopCondition con, Model model) {
        Page shops = this.service.findShopRecords(con, id, pageno);
        model.addAttribute("shops", (Object)shops);
        model.addAttribute("condition", (Object)con);
        return "shop/records.ftl";
    }

    private void getSalesMan(Model model, Employee me) {
        String id = me.getCurrentPartner().getOrganizationid();
        if (StringUtils.isNotEmpty(id)) {
            List<Contact> contList = this.service.getSalesMan(id);
            model.addAttribute("contList", contList);
        }
    }

    private void getSalesName(Model model, String id) {
        String saleManName = "";
        if (StringUtils.isNotEmpty(id)) {
            saleManName = this.service.getSalesManName(id);
            model.addAttribute("saleManName", (Object)saleManName);
        }
    }

    @RequestMapping(value={"/shopExcel.do"}, method={RequestMethod.GET})
    public String toShopExcel(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("con", (Object)con);
        return "shop/shopExcel.ftl";
    }

    @RequestMapping(value={"/shopExcel.do"}, method={RequestMethod.POST})
    public String shopBatch(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "shop");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<Shop> list = new ArrayList<Shop>();
        ArrayList<AdjustStockUtil> msglist = new ArrayList();
        msglist = this.excelVaildateService.readShopByExcel(url, em, list);
        return this.excelReturn(con, list, msglist, filelist, model);
    }

    @RequestMapping(value={"/showError.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result showError(Model model) throws Exception {
        model.addAttribute("errorMap", errorMap);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer("");
        Set<String> keys = errorMap.keySet();
        for (String key : keys) {
            sb.append("\u4e0a\u4f20\u65f6\u95f4\uff1a");
            sb.append(sdf.format(new Date(Long.valueOf(key))));
            sb.append("\u6267\u884c\u7ed3\u679c\uff1a");
            sb.append(errorMap.get(key));
        }
        return this.getSuccessResult(sb.toString());
    }

    public String excelReturn(ShopCondition con, final List<Shop> list, List<AdjustStockUtil> msglist, List<IUploadFile> filelist, Model model) {
        final Employee me = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() < 1) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        Set<String> keys = errorMap.keySet();
        for (String key : keys) {
            errorMap.remove(key);
        }
        final String id = String.valueOf(System.currentTimeMillis());
        Thread t = new Thread(){

            @Override
            public void run() {
                String rtnStr = ShopController.this.service.saveBatchShop(list, me);
                if (rtnStr != null && "".equals(rtnStr)) {
                    errorMap.put(id, "\u6267\u884c\u5b8c\u6210");
                } else {
                    errorMap.put(id, rtnStr);
                }
            }
        };
        errorMap.put(id, "\u6267\u884c\u4e2d");
        t.start();
        rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/findShopReport.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findShopReport(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShopReportCondition con, Model model) throws Exception {
        Employee me = this.getCurrentEmployee();
        Contact ep = this.personnelService.get(me.getId());
        Page shopViews = this.service.findShopReport(con, ep, pageno);
        model.addAttribute("shopViews", (Object)shopViews);
        model.addAttribute("condition", (Object)con);
        return "shop/report.ftl";
    }
}

