/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shop;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ContactShop;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.entity.ShopAddress;
import com.tcbj.crm.entity.ShopContacts;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopReportCondition;
import com.tcbj.crm.siebel.service.ShopSiebelService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ShopAccountView;
import com.tcbj.crm.view.ShopView;
import com.tcbj.crm.view.ShopViewAddress;
import com.tcbj.crm.view.ShopViewContats;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="shopService")
public class ShopService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private StorageService storageService;
    @Autowired
    OrderNoService orderNoService;

    public Page findShopApplys(ShopCondition condition, Employee e, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append(" select s  from Shop s  where s.applyType=? ");
        if ("update".equals(condition.getApplyType())) {
            args.add(ShopEnum.ApplyType.edit.getValue());
        } else {
            args.add(ShopEnum.ApplyType.add.getValue());
        }
        HQL.append(" and ( sysdate <= s.endDate or s.endDate is null )");
        HQL.append(" and s.creatorId = ? ");
        args.add(e.getId());
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getName())) {
            HQL.append(" and s.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
            HQL.append(" and s.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
            HQL.append(" and s.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and s.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
            HQL.append(" and s.shopType=? ");
            args.add(condition.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
            HQL.append(" and s.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
            HQL.append(" and s.cityId=? ");
            args.add(condition.getCityId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
            HQL.append(" and s.countyId=? ");
            args.add(condition.getCountyId());
        }
        HQL.append(" order by s.createDt desc,s.lastUpdateDt desc ");
        System.out.println("------sql------" + HQL.toString());
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Shop getShopById(String id) {
        Shop shop = (Shop)this.baseDao.get(Shop.class, (Serializable)((Object)id));
        shop.setAddresses(this.getAdress(id));
        shop.setContactses(this.getContacts(id));
        shop.setParStrAssign(this.loadPartnerStrAssign(shop.getParentDealerId()));
        return shop;
    }

    private List<ShopContacts> getContacts(String id) {
        String hql = " from ShopContacts where shopId=? ";
        return this.baseDao.findEntity(hql, new Object[]{id}, ShopContacts.class);
    }

    private List<ShopAddress> getAdress(String id) {
        String hql = " from ShopAddress where shopId=? ";
        return this.baseDao.findEntity(hql, new Object[]{id}, ShopAddress.class);
    }

    public void add(Shop shop, Employee me) {
        this.baseDao.save((Object)shop);
        for (ShopAddress address : shop.getAddresses()) {
            if (com.tcbj.util.StringUtils.isNotEmpty(address.getId())) {
                address.setSiebelAddressId(address.getId());
            }
            address.setShopId(shop.getId());
            address.fillInitData(me);
            this.baseDao.save((Object)address);
        }
        for (ShopContacts contacts : shop.getContactses()) {
            if (com.tcbj.util.StringUtils.isNotEmpty(contacts.getId())) {
                contacts.setSiebelContactsId(contacts.getId());
            }
            contacts.setShopId(shop.getId());
            contacts.fillInitData(me);
            this.baseDao.save((Object)contacts);
        }
    }

    public void update(Shop shop, Employee me) {
        Object[] args = new Object[]{shop.getId()};
        this.baseDao.update((Object)shop);
        this.baseDao.executeHQL("delete ShopAddress where shopId=?", args);
        this.baseDao.executeHQL("delete ShopContacts where shopId=?", args);
        for (ShopAddress address : shop.getAddresses()) {
            address.setShopId(shop.getId());
            address.fillInitData(me);
            this.baseDao.save((Object)address);
        }
        for (ShopContacts contact : shop.getContactses()) {
            contact.setShopId(shop.getId());
            this.baseDao.save((Object)contact);
        }
    }

    public void del(String id) {
        Shop shop = (Shop)this.baseDao.get(Shop.class, (Serializable)((Object)id));
        if (!shop.getApproveState().equals(ShopEnum.ApproveState.draft.getValue())) {
            throw new AppException("2001");
        }
        Object[] args = new Object[]{shop.getId()};
        this.baseDao.executeHQL("delete ShopAddress where shopId=?", args);
        this.baseDao.executeHQL("delete ShopContacts where shopId=?", args);
        this.baseDao.executeHQL("delete Shop where id=?", args);
    }

    public Page findShopAudits(ShopCondition condition, int pageno, Employee me) {
        return this.getOrgManageShops(condition, pageno, me);
    }

    private Page getOrgManageShops(ShopCondition condition, int pageno, Employee me) {
        StringBuilder HQL = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(me.getId());
        HQL.append(" select s  from Shop s ,Region r  where s.areaId=r.id  ");
        HQL.append("  and s.areaId in ( ");
        HQL.append(regions);
        HQL.append(" )");
        if ("dealed".equals(condition.getAuditType())) {
            HQL.append(" and ( s.approveState= ? or s.approveState=?) and  s.startDate <= ? and ( ? < s.endDate or s.endDate is null) ");
            args.add(ShopEnum.ApproveState.pass.getValue());
            args.add(ShopEnum.ApproveState.notpass.getValue());
            args.add(new Date());
            args.add(new Date());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
            HQL.append(" and s.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
            HQL.append(" and s.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
            HQL.append(" and s.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and s.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
            HQL.append(" and s.shopType=? ");
            args.add(condition.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
            HQL.append(" and s.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
            HQL.append(" and s.cityId=? ");
            args.add(condition.getCityId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
            HQL.append(" and s.countyId=? ");
            args.add(condition.getCountyId());
        }
        if ("dealing".equals(condition.getAuditType())) {
            HQL.append(" and s.approveState = ? and s.applyType in ( ?,? )");
            args.add(ShopEnum.ApproveState.audit.getValue());
            args.add(ShopEnum.ApplyType.add.getValue());
            args.add(ShopEnum.ApplyType.edit.getValue());
        }
        HQL.append(" order by s.createDt DESC,s.lastUpdateDt desc  ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    private Page getRegionManagerShops(ShopCondition condition, int pageno, Employee me) {
        StringBuilder HQL = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        Set<String> regions = this.personnelService.getRegionsByDutyType(me.getId());
        HQL.append(" select s  from Shop s ,Region r where s.areaId=r.id ");
        if (regions.size() > 0) {
            HQL.append("  and s.areaId in ( ");
            int i = 0;
            while (i < regions.size()) {
                HQL.append(i == 0 ? "?" : ",? ");
                ++i;
            }
            for (String id : regions) {
                args.add(id);
            }
            HQL.append(" )");
            HQL.append(" and  s.startDate <= ? and ( ? < s.endDate or s.endDate is null)");
            args.add(new Date());
            args.add(new Date());
            if ("dealing".equals(condition.getAuditType())) {
                HQL.append(" and s.approveState = ? and s.applyType in ( ?,? )");
                args.add(ShopEnum.ApproveState.audit.getValue());
                args.add(ShopEnum.ApplyType.add.getValue());
                args.add(ShopEnum.ApplyType.edit.getValue());
            }
            if ("dealed".equals(condition.getAuditType())) {
                HQL.append(" and ( s.approveState= ? or s.approveState=?)");
                args.add(ShopEnum.ApproveState.pass.getValue());
                args.add(ShopEnum.ApproveState.notpass.getValue());
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
                HQL.append(" and s.shopName like ?");
                args.add("%" + condition.getName().trim() + "%");
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
                HQL.append(" and s.shopNumber like ? ");
                args.add("%" + condition.getShopNumber() + "%");
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
                HQL.append(" and s.bigAreaId=?");
                args.add(condition.getBigAreaId());
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
                HQL.append(" and areaId= ? ");
                args.add(condition.getAreaId());
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
                HQL.append(" and s.shopType=? ");
                args.add(condition.getShopType());
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
                HQL.append(" and s.provinceId=? ");
                args.add(condition.getProvinceId());
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
                HQL.append(" and cityId=? ");
                args.add(condition.getCityId());
            }
            if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
                HQL.append(" and s.countyId=? ");
                args.add(condition.getCountyId());
            }
            HQL.append(" order by s.createDt DESC,s.lastUpdateDt desc  ");
            return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        }
        return null;
    }

    public void saveAudit(String id, String approveState, Employee me, String approveRemark, String type) {
        String siebelId = null;
        if ("2".equals(approveState)) {
            ShopSiebelService ss = new ShopSiebelService();
            siebelId = ss.addOrUpdateShopToSiebel(this.getShopById(id), type, me);
            if ("insert".equals(type)) {
                this.storageService.addStorage(siebelId, me);
            }
            String hql = "update Shop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,siebelShopId=? where id=?";
            Object[] args = new Object[]{approveState, approveRemark, me.getId(), DateUtils.now(), siebelId, id};
            this.baseDao.executeHQL(hql, args);
        } else {
            String hql = "update Shop set approveState=?,approveRemark=?,auditorId=?,auditDate=? where id=?";
            Object[] args = new Object[]{approveState, approveRemark, me.getId(), DateUtils.now(), id};
            this.baseDao.executeHQL(hql, args);
        }
    }

    public Page findShopViews(ShopCondition condition, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        String regions = this.personnelService.getFRegionsByUserId(me.getId());
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c from ShopView c where  ");
        hql.append(" not exists( select 1 from Shop s where s.siebelShopId = c.id and s.applyType='2' and s.approveState='1')");
        if (me.getCurrentPartner().isOrg()) {
            hql.append(" and ( c.salseManId=?  ");
            args.add(me.getId());
            hql.append(" or ( ");
            hql.append(" c.areaId in ( ");
            hql.append(regions);
            hql.append(")");
            hql.append(") )");
        } else {
            hql.append(" and c.parentDealerId=? ");
            args.add(me.getCurrentPartner().getId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
            hql.append(" and c.shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by c.createDt desc ,c.lastUpdateDt desc ");
        System.out.println("-----hql-----" + hql.toString());
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<ShopView> temp = new ArrayList<ShopView>();
        for (ShopView shopView : page.getList()) {
            if (com.tcbj.util.StringUtils.isNotEmpty(shopView.getParentDealerId())) {
                shopView.setParStrAssign(this.loadPartnerStrAssign(shopView.getParentDealerId()));
            }
            temp.add(shopView);
        }
        page.setList(temp);
        return page;
    }

    private String loadPartnerStrAssign(String partnertId) {
        if (com.tcbj.util.StringUtils.isEmpty(partnertId)) {
            return null;
        }
        String sql = " select level, capv.Name from CX_AWK_PARTNERLIST_VIEW capv  where capv.Row_Id <> ? start with capv.Row_Id = ? connect by prior capv.ParPartnerId = capv.Row_Id order by level desc";
        List list = this.baseDao.findBySql(sql, new Object[]{partnertId, partnertId});
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)partnertId));
        ArrayList<Partner> paList = new ArrayList<Partner>();
        for (Object[] obj : list) {
            Partner p = new Partner();
            p.setName((String)obj[1]);
            paList.add(p);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paList.size()) {
            sb.append(i % 2 == 0 ? ((Partner)paList.get(i)).getName() : "--->" + ((Partner)paList.get(i)).getName());
            ++i;
        }
        sb.append(com.tcbj.util.StringUtils.isEmpty(sb.toString()) ? partner.getName() : "--->" + partner.getName());
        return sb.toString();
    }

    public ShopView getShopView(String siebelShopId) {
        ShopView shopView = (ShopView)this.baseDao.get(ShopView.class, (Serializable)((Object)siebelShopId));
        String hql = "from  ShopViewContats where shopId=? and isContact='Y'";
        String hql_1 = "  from ShopViewAddress  where shopId=?";
        String hql_2 = " from  ShopAccountView where partnerid=? and orgId=? ";
        ShopAccountView sav = (ShopAccountView)this.baseDao.findFirstEntity(hql_2, new Object[]{shopView.getId(), shopView.getParentDealerId()}, ShopAccountView.class);
        if (sav != null) {
            String shopId = sav.getId();
            shopView.setAddresses(this.baseDao.findEntity(hql_1, new Object[]{shopId}, ShopViewAddress.class));
        }
        shopView.setContacts(this.baseDao.findEntity(hql, new Object[]{siebelShopId}, ShopViewContats.class));
        shopView.setParStrAssign(this.loadPartnerStrAssign(shopView.getParentDealerId()));
        return shopView;
    }

    public Page findShopRecords(ShopCondition condition, String siebelId, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Shop where siebelShopId=?");
        args.add(siebelId);
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
            HQL.append(" and shopName like ?");
            args.add("%" + condition.getName().trim() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
            HQL.append(" and shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
            HQL.append(" and bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
            HQL.append(" and shopType=? ");
            args.add(condition.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
            HQL.append(" and provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
            HQL.append(" and cityId=? ");
            args.add(condition.getCityId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
            HQL.append(" and countyId=? ");
            args.add(condition.getCountyId());
        }
        HQL.append(" order by createDt desc ,lastUpdateDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<Contact> getSalesMan(String id) {
        String hql = " from  Contact where partnerOrgId= ?";
        return this.baseDao.findEntity(hql, new Object[]{id}, Contact.class);
    }

    public String getSalesManName(String salseManId) {
        Contact contact = (Contact)this.baseDao.get(Contact.class, (Serializable)((Object)salseManId));
        if (contact != null) {
            return contact.getFullname();
        }
        return "";
    }

    public Page getShops(ShopCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from ShopView s where 1=1");
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getParentDealerId())) {
            HQL.append("and s.parentDealerId = ?");
            args.add(con.getParentDealerId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getShopType())) {
            HQL.append("and s.shopType = ?");
            args.add(con.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getName())) {
            HQL.append("and s.shopName like ?");
            args.add("%" + con.getName() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getShopNumber())) {
            HQL.append("and s.shopNumber = ?");
            args.add(con.getShopNumber());
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public ShopView getCodeByShop(String code, String supplierId) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from ShopView where parentDealerId=? and shopNumber = ? ");
        args.add(supplierId);
        args.add(code);
        return (ShopView)this.baseDao.findFirstEntity(HQL.toString(), args.toArray(), ShopView.class);
    }

    public boolean isShop(String code, String supplierId) {
        return !com.tcbj.util.StringUtils.isNotNull(this.getCodeByShop(code, supplierId));
    }

    public Long getDraftShopList(Employee me) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select Count(s) from Shop s where s.applyType=? and s.approveState=? and s.parentDealerId =?");
        ArrayList<String> args = new ArrayList<String>();
        args.add(ShopEnum.ApplyType.add.getValue());
        args.add(ShopEnum.ApproveState.draft.getValue());
        args.add(me.getCurrentPartner().getId());
        Long count = (Long)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Long.class);
        return count;
    }

    public Long getAuditShopCount(Employee me) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select Count(s) from Shop s where s.applyType in ( ?,? ) and s.approveState=? and s.parentDealerId =?");
        ArrayList<String> args = new ArrayList<String>();
        args.add(ShopEnum.ApplyType.add.getValue());
        args.add(ShopEnum.ApplyType.edit.getValue());
        args.add(ShopEnum.ApproveState.audit.getValue());
        args.add(me.getCurrentPartner().getId());
        Long count = (Long)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Long.class);
        return count;
    }

    public boolean isUpdateMeanwhile(String siebelId) {
        return false;
    }

    public String getShopNo() {
        String sql = " select cx_shop_no_seq.CURRVAL from dual ";
        List obj = this.baseDao.findBySql(sql);
        System.out.println("obj====" + obj.get(0));
        return String.valueOf(obj.get(0));
    }

    public boolean validateShopName(Employee me, String shopId, String shopName) {
        List shopList;
        StringBuffer hql = new StringBuffer();
        hql.append(" from Shop where parentDealerId=? and shopName= ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(me.getCurrentPartner().getId());
        args.add(shopName);
        if (com.tcbj.util.StringUtils.isNotEmpty(shopId)) {
            hql.append(" and  id <> ? ");
            args.add(shopId);
        }
        return (shopList = this.baseDao.findEntity(hql.toString(), args.toArray(), Shop.class)).size() == 0;
    }

    public boolean validateCilentNo(Employee me, String outClientNo) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        if (com.tcbj.util.StringUtils.isEmpty(StringUtils.trimAllWhitespace((String)outClientNo))) {
            return true;
        }
        hql.append(" from ShopView where  outerClientNo=? ");
        args.add(outClientNo);
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopView.class);
        return list.size() == 0;
    }

    public PartnerContact getCurentSaleMan(String partnerId, String salseManId) {
        if (com.tcbj.util.StringUtils.isNotEmpty(salseManId)) {
            String hql = " from PartnerContact where partnerId=? and id=? ";
            return (PartnerContact)this.baseDao.findFirstEntity(hql, new Object[]{partnerId, salseManId}, PartnerContact.class);
        }
        return null;
    }

    public boolean validateSiebleShopName(String parentPartnerId, String id, String shopName) {
        String hql = " from ShopView where parentDealerId=? and id<> ? and shopName =? ";
        List shopViewList = this.baseDao.findEntity(hql, new Object[]{parentPartnerId, id, shopName}, ShopView.class);
        return shopViewList.size() == 0;
    }

    public Page getSelectShop(ShopCondition condition, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c from ShopView c where 1=1 ");
        hql.append(" and c.id not in(select s.shopId from ContactShop s where s.userId = ? ) ");
        args.add(condition.getUserId());
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(condition.getName().replaceAll("\uff0c", ","));
            if (condition.getName().indexOf(",") != -1 && condition.getName().split(",").length > 1) {
                String[] nos = condition.getName().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    if (i == 0) {
                        hql.append(" and ((upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    } else if (i == nos.length - 1) {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%')))");
                    } else {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    }
                    ++i;
                }
            } else {
                hql.append("and (c.shopName like ? or c.shopNumber like ?) ");
                args.add("%" + condition.getName().trim() + "%");
                args.add("%" + condition.getName().trim() + "%");
            }
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by shopNumber ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        return page;
    }

    public Page getPostShop(ShopCondition condition, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" select c from ShopView c where 1=1 ");
        hql.append(" and c.id not in(select s.shopId from PostShop s where s.postId = ? ) ");
        args.add(condition.getUserId());
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(condition.getName().replaceAll("\uff0c", ","));
            if (condition.getName().indexOf(",") != -1 && condition.getName().split(",").length > 1) {
                String[] nos = condition.getName().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    if (i == 0) {
                        hql.append(" and ((upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    } else if (i == nos.length - 1) {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%')))");
                    } else {
                        hql.append(" or (upper(c.shopNumber) like upper('%" + no + "%') or upper(c.shopName) like upper('%" + no + "%'))");
                    }
                    ++i;
                }
            } else {
                hql.append("and (c.shopName like ? or c.shopNumber like ?) ");
                args.add("%" + condition.getName().trim() + "%");
                args.add("%" + condition.getName().trim() + "%");
            }
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopNumber())) {
            hql.append(" and c.shopNumber like ? ");
            args.add("%" + condition.getShopNumber() + "%");
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getBigAreaId())) {
            hql.append(" and c.bigAreaId=?");
            args.add(condition.getBigAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getAreaId())) {
            hql.append(" and c.areaId= ? ");
            args.add(condition.getAreaId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getShopType())) {
            hql.append(" and c.shopType=? ");
            args.add(condition.getShopType());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getProvinceId())) {
            hql.append(" and c.provinceId=? ");
            args.add(condition.getProvinceId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCityId())) {
            hql.append(" and c.cityId=? ");
            args.add(condition.getCityId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(condition.getCountyId())) {
            hql.append(" and c.countyId=? ");
            args.add(condition.getCountyId());
        }
        hql.append(" and ( c.endDate >= ? or c.endDate is null ) ");
        args.add(DateUtils.getStartTime());
        hql.append(" order by shopNumber ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        return page;
    }

    public String saveBatchShop(List<Shop> list, Employee me) {
        ShopSiebelService ss = new ShopSiebelService();
        for (Shop shop : list) {
            shop.setShopNumber(this.orderNoService.updateShopNo("200001", true));
        }
        String msg = ss.addShopToSiebel2(list, "insert", me);
        return msg;
    }

    public boolean validateShopViewName(Employee me, String shopName, String address) {
        List shopList;
        StringBuffer hql = new StringBuffer();
        hql.append(" from ShopView where parentDealerId=? and shopName= ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(me.getCurrentPartner().getId());
        args.add(shopName);
        if (com.tcbj.util.StringUtils.isNotEmpty(address)) {
            hql.append(" and addressDetails = ? ");
            args.add(address);
        }
        return (shopList = this.baseDao.findEntity(hql.toString(), args.toArray(), Shop.class)).size() == 0;
    }

    public String validateShopUnique(String partnerName, String shopName, String address) {
        List list;
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        if (com.tcbj.util.StringUtils.isEmpty(partnerName) || com.tcbj.util.StringUtils.isEmpty(shopName)) {
            return "\u4e0a\u7ea7\u7ecf\u9500\u5546\u6216\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a\u3002";
        }
        hql.append(" from ShopView s where s.parPartnerName=? and s.shopName=? ");
        args.add(partnerName);
        args.add(shopName);
        if (com.tcbj.util.StringUtils.isNotEmpty(address)) {
            hql.append(" and s.addressDetails = ? ");
            args.add(address);
        }
        if ((list = this.baseDao.findEntity(hql.toString(), args.toArray(), ShopView.class)).size() > 0) {
            return "\u8be5\u95e8\u5e97\u5df2\u7ecf\u5b58\u5728\u3002";
        }
        return null;
    }

    public List<AdjustStockUtil> update(List<List<Object>> objs, Employee employee) {
        ArrayList<AdjustStockUtil> msgList = new ArrayList<AdjustStockUtil>();
        HashMap<String, String> shopListMap = new HashMap<String, String>();
        HashMap<String, String> partnerContactsMap = new HashMap<String, String>();
        ArrayList<ContactShop> list = new ArrayList<ContactShop>();
        ContactShop t = null;
        int i = 0;
        while (i < objs.size()) {
            List<Object> item = objs.get(i);
            String shopNumber = (String)item.get(0);
            if (com.tcbj.util.StringUtils.isEmpty(shopNumber)) {
                msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            } else {
                ShopView shopView = (ShopView)this.baseDao.findFirstEntity("from ShopView where shopNumber = ? ", new Object[]{shopNumber}, ShopView.class);
                if (shopView == null) {
                    msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u95e8\u5e97\u7f16\u53f7\u4e0d\u6b63\u786e\u3002"));
                } else {
                    shopListMap.put(shopView.getShopNumber(), shopView.getId());
                }
            }
            HashSet<String> set = new HashSet<String>();
            if (com.tcbj.util.StringUtils.isNotEmpty(shopNumber)) {
                String scdb;
                String csjl;
                String qyjl;
                String dqjl = (String)item.get(2);
                if (com.tcbj.util.StringUtils.isNotEmpty(dqjl)) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{dqjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u5927\u533a\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(dqjl);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                if (com.tcbj.util.StringUtils.isNotEmpty(qyjl = (String)item.get(3))) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{qyjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u533a\u57df\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(qyjl);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                if (com.tcbj.util.StringUtils.isNotEmpty(csjl = (String)item.get(4))) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{csjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u57ce\u5e02\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(csjl);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                if (com.tcbj.util.StringUtils.isNotEmpty(scdb = (String)item.get(5))) {
                    PartnerContact partnerContact = (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where no = ? ", new Object[]{csjl}, PartnerContact.class);
                    if (partnerContact == null) {
                        msgList.add(new AdjustStockUtil("\u7b2c" + i + "\u884c\uff0c\u57ce\u5e02\u7ecf\u7406\u4e0d\u6b63\u786e\u3002"));
                    } else {
                        set.add(scdb);
                        partnerContactsMap.put(partnerContact.getNo(), partnerContact.getId());
                    }
                }
                for (String name : set) {
                    ContactShop contactShop = (ContactShop)this.baseDao.findFirstEntity("from ContactShop where userId = ? and shopId = ? ", new Object[]{partnerContactsMap.get(name), shopListMap.get(shopNumber)}, ContactShop.class);
                    if (contactShop != null || !com.tcbj.util.StringUtils.isNotEmpty((String)partnerContactsMap.get(name)) || shopListMap.get(shopNumber) == null || !com.tcbj.util.StringUtils.isNotEmpty((String)shopListMap.get(shopNumber))) continue;
                    t = new ContactShop();
                    t.setShopId((String)shopListMap.get(shopNumber));
                    t.setUserId((String)partnerContactsMap.get(name));
                    t.setCreateDt(new Date());
                    t.setStartDate(new Date());
                    t.setLastUpdateDt(new Date());
                    t.setLastUpdatorId("0-8");
                    t.setCreatorId("0-8");
                    list.add(t);
                }
            }
            ++i;
        }
        if (msgList.size() > 0) {
            return msgList;
        }
        this.baseDao.save(list);
        return msgList;
    }

    public Page findShopReport(ShopReportCondition condition, Contact ep, int pageno) {
        String shopNo = "";
        if (!"Order Manager".equals(ep.getRoletype())) {
            String hql = "select s from ContactShop c,ShopView s where c.shopId = s.id and c.userId = ?";
            List shopList = this.baseDao.findEntity(hql, new Object[]{ep.getId()}, ShopView.class);
            for (ShopView shopView : shopList) {
                shopNo = String.valueOf(shopNo) + "'" + shopView.getShopNumber() + "',";
            }
        }
        ArrayList args = new ArrayList();
        StringBuffer sb = new StringBuffer();
        sb.append(" select * from (SELECT b.bh_one_level_accountname as dealerName, b.bh_one_level_channelname as bigAreaName,  ");
        sb.append(" b.bh_two_level_channelname as areaName, b. bh_three_level_channelname as orgName,b.bh_no as shopNo, ");
        sb.append("  b.bh_name as shopName,b.bh_storeid as id, c.last_name AS personName, c.CELL_PH_NUM AS mobile, ");
        sb.append(" (case when CON_CD = 'Chain Manager' then  '\u8fde\u9501\u7ba1\u7406\u8005'  when CON_CD = 'City Manager' then  '\u57ce\u5e02\u7ecf\u7406'");
        sb.append(" when CON_CD = 'Consumer' then '\u6d88\u8d39\u8005'  when CON_CD = 'DataManager' then  '\u6570\u636e\u7ba1\u7406\u4eba\u5458'");
        sb.append(" when CON_CD = 'Distict Manager' then '\u5927\u533a\u7ecf\u7406'  when CON_CD = 'Order Manager' then  '\u8ba2\u5355\u4e13\u5458' ");
        sb.append(" when CON_CD = 'Purchase Manager' then   '\u91c7\u8d2d\u7ecf\u7406'  when CON_CD = 'Region Manager' then  '\u533a\u57df\u7ecf\u7406' ");
        sb.append(" when CON_CD = 'Sales Clerk' then   '\u5e97\u5458'  when CON_CD = 'Sales Promoter' then  '\u4fc3\u9500\u5458' ");
        sb.append(" when CON_CD = 'Store Manager' then  '\u5e97\u957f'   when CON_CD = 'SysAdmin' then 'SysAdmin'   else  ''  end)  ");
        sb.append("as duty,");
        sb.append("  b.bh_supper_storeno as multipleNo,  b.bh_supper_storename as multipleName, ");
        sb.append("  SUM(MEMACCRUEPOINTS) AS newMemAccruePoints, SUM(MEMNUM) as memAmount, SUM(NEWMEMNUM) as newMemAmount ");
        sb.append(" FROM ");
        sb.append(" ( ");
        sb.append(" SELECT BH_STOREID,  BH_STORE_CLERKID,  SUM(MEMACCRUEPOINTS) AS MEMACCRUEPOINTS,  0 AS MEMNUM, 0 AS NEWMEMNUM ");
        sb.append(" FROM CX_AWK_STORE_MEMBER_POINTS  WHERE CREATEDON BETWEEN to_date('").append(condition.getcDate());
        sb.append("','yyyyMMdd') AND to_date('").append(condition.geteDate()).append("','yyyyMMdd')");
        sb.append(" GROUP BY BH_STOREID, BH_STORE_CLERKID ");
        sb.append(" union all ");
        sb.append(" SELECT BH_STOREID,  BH_STORE_CLERKID, 0 AS MEMACCRUEPOINTS,  count(distinct bh_contactid) AS MEMNUM,   0 AS NEWMEMNUM ");
        sb.append(" FROM CX_AWK_STORE_MEMBER_detail  WHERE rtype = 1 and CREATEDON BETWEEN to_date('").append(condition.getcDate());
        sb.append("' , 'yyyyMMdd') AND  to_date('").append(condition.geteDate()).append("' , 'yyyyMMdd') ");
        sb.append(" GROUP BY BH_STOREID, BH_STORE_CLERKID");
        sb.append(" union all ");
        sb.append(" SELECT BH_STOREID,  BH_STORE_CLERKID,   0 AS MEMACCRUEPOINTS,   0 AS MEMNUM,   count(distinct bh_contactid) AS NEWMEMNUM");
        sb.append(" FROM CX_AWK_STORE_MEMBER_detail  WHERE rtype = 2 and CREATEDON BETWEEN to_date('").append(condition.getcDate());
        sb.append("' , 'yyyyMMdd') AND  to_date('").append(condition.geteDate()).append("' , 'yyyyMMdd') ");
        sb.append(" GROUP BY BH_STOREID, BH_STORE_CLERKID ");
        sb.append(" ) A ");
        sb.append(" LEFT OUTER JOIN ");
        sb.append(" ( SELECT ");
        sb.append(" (case  when NVL(CCSN, '9999') IN ('TCBJ', '9999') THEN (CASE  WHEN NVL(BCSN, '9999') IN ('TCBJ', '9999') THEN ANAME  ELSE  BNAME  END)   ELSE  CNAME  END) ");
        sb.append("AS bh_one_level_accountname, ");
        sb.append(" (CASE WHEN e.REGION_NAME = '\u4f70\u5065\u8425\u517b\u4e2d\u5fc3' THEN  '\u4f70\u5065'  WHEN e.REGION_NAME = '\u5b89\u5fbd\u533a' THEN 'TBC'   ELSE  e.REGION_NAME  END)");
        sb.append("as bh_one_level_channelname, ");
        sb.append(" (CASE WHEN d.REGION_NAME = '\u8425\u517b\u4e2d\u5fc3' THEN   '\u4f70\u5065'  WHEN d.REGION_NAME = '\u6e56\u5317\u4e00\u533a' THEN   '\u6e56\u53171\u533a'   WHEN d.REGION_NAME = '\u6e56\u5317\u4e8c\u533a' ");
        sb.append(" THEN  '\u6e56\u53172\u533a'   WHEN d.REGION_NAME = '\u56db\u5ddd\u4e00\u533a' THEN  '\u56db\u5ddd1\u533a'  WHEN d.REGION_NAME = '\u56db\u5ddd\u4e8c\u533a' THEN  '\u56db\u5ddd2\u533a'   ELSE   d.REGION_NAME    END)");
        sb.append("As bh_two_level_channelname,");
        sb.append(" city as bh_three_level_channelname,  csn as bh_no,   name as bh_name,   c.row_id as bh_storeid,  smname as bh_manager, ");
        sb.append(" smphone as bh_manager_telephone, position as bh_manager_position,  c.acsn as bh_supper_storeno,  c.aname as bh_supper_storename ");
        sb.append(" FROM cx_awk_rptpartner_forgw c  left outer JOIN S_ORG_PRTNR b   on c.row_id = b.par_ROW_ID  ");
        sb.append(" left outer join CX_REGION_MAIN e on b.X_DISTRICT_ID = e.ROW_ID ");
        sb.append(" left outer join CX_REGION_MAIN d  on b.X_REGION_ID = d.ROW_ID  ");
        sb.append(" ) B ");
        sb.append(" on A.BH_STOREID = B.bh_storeid ");
        sb.append(" left outer join S_CONTACT c  on a.BH_STORE_CLERKID = c.ROW_iD");
        sb.append(" GROUP BY b.bh_one_level_accountname,   b.bh_one_level_channelname, b.bh_two_level_channelname, ");
        sb.append(" b. bh_three_level_channelname, a.BH_STORE_CLERKID,b.bh_no,   b.bh_name,   b.bh_storeid, ");
        sb.append(" c.last_name,   c.CELL_PH_NUM,  c.CON_CD,   b.bh_supper_storeno,   b.bh_supper_storename");
        sb.append(") t1 where 1=1 ");
        if (!com.tcbj.util.StringUtils.isEmpty(shopNo)) {
            shopNo = shopNo.substring(0, shopNo.length() - 1);
            sb.append(" and t1.shopNo in (").append(shopNo).append(") ");
        }
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getShopNo())) {
            sb.append(" and t1.shopNo like '%").append(condition.getShopNo()).append("%' ");
        }
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getShopName())) {
            sb.append(" and t1.shopName like '%").append(condition.getShopName()).append("%' ");
        }
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getBigAreaName())) {
            sb.append(" and t1.bigAreaName like '%").append(condition.getBigAreaName()).append("%' ");
        }
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getAreaName())) {
            sb.append(" and t1.areaName like '%").append(condition.getAreaName()).append("%' ");
        }
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getMultipleNo())) {
            sb.append(" and t1.multipleNo like '%").append(condition.getMultipleNo()).append("%' ");
        }
        if (!com.tcbj.util.StringUtils.isEmpty(condition.getMultipleName())) {
            sb.append(" and t1.multipleName like '%").append(condition.getMultipleName()).append("%' ");
        }
        new ArrayList();
        Page page = this.baseDao.searchBySql(sb.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, null);
        ArrayList<ShopReportCondition> listReport = new ArrayList<ShopReportCondition>();
        List listObj = page.getList();
        for (Object[] objects : listObj) {
            ShopReportCondition report = new ShopReportCondition();
            report.setDealerName(this.checkEmp(objects[0]));
            report.setBigAreaName(this.checkEmp(objects[1]));
            report.setAreaName(this.checkEmp(objects[2]));
            report.setOrgName(this.checkEmp(objects[3]));
            report.setShopNo(this.checkEmp(objects[4]));
            report.setShopName(this.checkEmp(objects[5]));
            report.setId(this.checkEmp(objects[6]));
            report.setPersonName(this.checkEmp(objects[7]));
            report.setMobile(this.checkEmp(objects[8]));
            report.setDuty(this.checkEmp(objects[9]));
            report.setMultipleNo(this.checkEmp(objects[10]));
            report.setMultipleName(this.checkEmp(objects[11]));
            report.setIntegral(this.checkEmp(objects[12]));
            report.setCustomerMun(this.checkEmp(objects[13]));
            report.setCustomerMunNew(this.checkEmp(objects[14]));
            listReport.add(report);
        }
        page.setList(listReport);
        return page;
    }

    public String checkEmp(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    private Map<String, Object> convertArrayToMap(String[] keys, Object[] array) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Object value = null;
            if (array.length > i) {
                value = array[i];
            }
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public static class Test {
        private String employeeId;
        private String shopId;

        public String getEmployeeId() {
            return this.employeeId;
        }

        public void setEmployeeId(String employeeId) {
            this.employeeId = employeeId;
        }

        public String getShopId() {
            return this.shopId;
        }

        public void setShopId(String shopId) {
            this.shopId = shopId;
        }
    }
}

