/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.siebel.service;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.entity.ShopAddress;
import com.tcbj.crm.entity.ShopContacts;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.siebel.service.SiebelUtil;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ShopSiebelService {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addOrUpdateShopToSiebel(Shop shop, String type, Employee me) {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService("Workflow Process Manager MRMJ");
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Store_IU_WF");
            String xml = this.parseShop2xml(shop, type, me);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            System.err.println("rtn--------" + rtn);
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            System.out.println();
            if (!rtn.equals("100")) {
                throw new AppException("0010", rtnDesc);
            }
            string = rowId;
        }
        catch (AppException e) {
            try {
                throw e;
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new AppException("0010", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addShopToSiebel2(List<Shop> list, String type, Employee me) {
        String string;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService("Workflow Process Manager MRMJ");
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Store_IU_WF");
            String xml = "";
            StringBuffer sBuffer = new StringBuffer("");
            int i = 0;
            while (true) {
                if (i >= list.size()) {
                    string = sBuffer.toString();
                    break;
                }
                xml = this.parseShop2xml(list.get(i), type, me);
                input.setProperty("InXml", xml);
                input.setProperty("Source", "TCBJCRM");
                businessService.invokeMethod("RunProcess", input, output);
                String rtn = output.getProperty("ErrCode");
                String rtnDesc = output.getProperty("ErrDesc");
                String rowId = output.getProperty("PrimaryRowId");
                if (!rtn.equals("100")) {
                    sBuffer.append(rtnDesc).append("\t");
                } else {
                    map.put("siebelId", rowId);
                }
                ++i;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new AppException("0010", e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> addShopToSiebel(Shop shop, String type, Employee me) {
        HashMap<String, String> hashMap;
        SiebelDataBean dataBean = null;
        SiebelService businessService = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            dataBean = SiebelUtil.connect();
            businessService = dataBean.getService("Workflow Process Manager MRMJ");
            SiebelPropertySet input = new SiebelPropertySet();
            SiebelPropertySet output = new SiebelPropertySet();
            input.setProperty("ProcessName", "TCBJ_Store_IU_WF");
            String xml = this.parseShop2xml(shop, type, me);
            input.setProperty("InXml", xml);
            input.setProperty("Source", "TCBJCRM");
            businessService.invokeMethod("RunProcess", input, output);
            String rtn = output.getProperty("ErrCode");
            System.err.println("rtn--------" + rtn);
            String rtnDesc = output.getProperty("ErrDesc");
            String rowId = output.getProperty("PrimaryRowId");
            System.out.println();
            if (!rtn.equals("100")) {
                map.put("rtnDes", rtnDesc);
            } else {
                map.put("siebelId", rowId);
            }
            hashMap = map;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new AppException("0010", e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    businessService.release();
                    dataBean.logoff();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            businessService.release();
            dataBean.logoff();
            return hashMap;
        }
        catch (Exception exception) {}
        return hashMap;
    }

    private String parseShop2xml(Shop s, String type, Employee me) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<ListOfChannelPartner><ChannelPartner>");
        sb.append("<Operation>").append(type).append("</Operation>");
        if (StringUtils.isNotEmpty(s.getSiebelShopId())) {
            sb.append("<Id>").append(s.getSiebelShopId()).append("</Id>");
        } else {
            sb.append("<Id>").append(s.getId()).append("</Id>");
        }
        sb.append("<Name>").append(s.getShopName()).append("</Name>");
        sb.append("<CSN>").append(s.getShopNumber()).append("</CSN>");
        if (StringUtils.isEmpty(s.getOuterClientNo())) {
            sb.append("<ExtCSN/>");
        } else {
            sb.append("<ExtCSN>\t").append(s.getOuterClientNo()).append("</ExtCSN>");
        }
        if (StringUtils.isEmpty(s.getShopTel())) {
            sb.append("<CompanyPhone/>");
        } else {
            sb.append("<CompanyPhone>").append(s.getShopTel()).append("</CompanyPhone>");
        }
        sb.append("<ParentId>").append(s.getParentDealerId()).append("</ParentId>");
        sb.append("<ParentName>").append(s.getParentDealerName()).append("</ParentName>");
        sb.append("<DistrictId>").append(s.getBigAreaId()).append("</DistrictId>");
        sb.append("<RegionId>").append(s.getAreaId()).append("</RegionId>");
        sb.append("<Category>\u95e8\u5e97</Category>");
        sb.append("<Country>\u4e2d\u56fd</Country>");
        sb.append("<State>").append(s.getProvinceName()).append("</State>");
        sb.append("<City>").append(s.getCityName()).append("</City>");
        if (StringUtils.isEmpty(s.getCountyName())) {
            sb.append("<County/>");
        } else {
            sb.append("<County>").append(s.getCountyName()).append("</County>");
        }
        if (StringUtils.isEmpty(s.getAddressDetails())) {
            sb.append("<CompanyAddress/>");
        } else {
            sb.append("<CompanyAddress>").append(s.getAddressDetails()).append("</CompanyAddress>");
        }
        sb.append("<DefRcvFlg>").append(s.getIsReceiveAllot()).append("</DefRcvFlg>");
        sb.append("<StoreSubType>").append(s.getShopClassifyName()).append("</StoreSubType>");
        sb.append("<StoreType>").append(s.getShopTypeName()).append("</StoreType>");
        if (s.getShopTotalArea() == null) {
            sb.append("<TotalArea/>");
        } else {
            sb.append("<TotalArea>").append(s.getShopTotalArea()).append("</TotalArea>");
        }
        if (s.getShopBrandArea() == null) {
            sb.append("<BrandArea/>");
        } else {
            sb.append("<BrandArea>").append(s.getShopBrandArea()).append("</BrandArea>");
        }
        if (s.getLatitude() == null) {
            sb.append("<Latitude/>");
        } else {
            sb.append("<Latitude>").append(s.getLatitude()).append("</Latitude>");
        }
        if (s.getLongitude() == null) {
            sb.append("<Longitude/>");
        } else {
            sb.append("<Longitude>").append(s.getLongitude()).append("</Longitude>");
        }
        if (s.getPromotionNumber() == null) {
            sb.append("<PromotionPerNumber/>");
        } else {
            sb.append("<PromotionPerNumber>").append(s.getPromotionNumber()).append("</PromotionPerNumber>");
        }
        if (s.getShoppeNumber() == null) {
            sb.append("<CounterNumber/>");
        } else {
            sb.append("<CounterNumber>").append(s.getShoppeNumber()).append("</CounterNumber>");
        }
        sb.append("<MemStoreFlg>").append(s.getIsMenberShop()).append("</MemStoreFlg>");
        sb.append("<TrmnlLvl>").append(s.getTerminalLevelName()).append("</TrmnlLvl>");
        sb.append("<PromtMode>").append(s.getPromotionModeName()).append("</PromtMode>");
        if (StringUtils.isEmpty(s.getSalseManId())) {
            sb.append("<SalesmanId/>");
        } else {
            sb.append("<SalesmanId>").append(s.getSalseManId()).append("</SalesmanId>");
        }
        if (s.getStartDate() == null) {
            sb.append("<StartDate></StartDate>");
        } else {
            sb.append("<StartDate>").append(DateUtils.formartDate((Date)s.getStartDate(), null)).append("</StartDate>");
        }
        if (s.getEndDate() == null) {
            sb.append("<EndDate></EndDate>");
        } else {
            sb.append("<EndDate>").append(DateUtils.formartDate((Date)s.getEndDate(), null)).append("</EndDate>");
        }
        sb.append("<CreatorId>").append(s.getCreatorId()).append("</CreatorId>");
        sb.append("<CreateDt>").append(DateUtils.formartDate((Date)s.getCreateDt(), null)).append("</CreateDt>");
        sb.append("<LastUpdatorId>").append(s.getLastUpdatorId()).append("</LastUpdatorId>");
        sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)s.getLastUpdateDt(), null)).append("</LastUpdateDt>");
        sb.append("<ListOfOrganization><Organization>");
        if (StringUtils.isEmpty(s.getParentDealerId())) {
            sb.append("<OrganizationId>");
        } else {
            sb.append("<OrganizationId>").append(s.getParentDealerId()).append("</OrganizationId>");
        }
        List<ShopAddress> addresses = s.getAddresses();
        if (addresses.size() > 0) {
            sb.append("<ListOfComAddress>");
            for (ShopAddress sa : addresses) {
                sb.append("<ComAddress>");
                if (StringUtils.isEmpty(sa.getSiebelAddressId())) {
                    sb.append("<Id>").append(sa.getId()).append("</Id>");
                } else {
                    sb.append("<Id>").append(sa.getSiebelAddressId()).append("</Id>");
                }
                sb.append("<Type>").append(sa.getAddressTypeName()).append("</Type>");
                if (StringUtils.isEmpty(sa.getContryName())) {
                    sb.append("<Country/>");
                } else {
                    sb.append("<Country>").append(sa.getContryName()).append("</Country>");
                }
                sb.append("<State>").append(sa.getProvinceName()).append("</State>");
                sb.append("<City>").append(sa.getCityName()).append("</City>");
                sb.append("<County>").append(sa.getCountyName()).append("</County>");
                sb.append("<StreetAddress>").append(sa.getAdressDetail()).append("</StreetAddress>");
                if (StringUtils.isEmpty(sa.getZipCode())) {
                    sb.append("<PostalCode/>");
                } else {
                    sb.append("<PostalCode>").append(sa.getZipCode()).append("</PostalCode>");
                }
                sb.append("<StartDate>").append(DateUtils.formartDate((Date)sa.getStartDate(), null)).append("</StartDate>");
                if (sa.getEndDate() == null) {
                    sb.append("<EndDate/>");
                } else {
                    sb.append("<EndDate>").append(DateUtils.formartDate((Date)sa.getEndDate(), null)).append("</EndDate>");
                }
                sb.append("<DefPerId>").append(sa.getDefaultContacts()).append("</DefPerId>");
                sb.append("<DefPerPhone>").append(sa.getContatsPhone()).append("</DefPerPhone>");
                sb.append("<CityManId></CityManId>");
                sb.append("<RcvDateType>").append(sa.getReceiveTimeName()).append("</RcvDateType>");
                sb.append("<CreatorId>").append(sa.getCreatorId()).append("</CreatorId>");
                sb.append("<CreateDt>").append(DateUtils.formartDate((Date)sa.getCreateDt(), null)).append("</CreateDt>");
                sb.append("<LastUpdatorId>").append(sa.getLastUpdatorId()).append("</LastUpdatorId>");
                sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)sa.getLastUpdateDt(), null)).append("</LastUpdateDt>");
                sb.append("</ComAddress>");
            }
            sb.append("</ListOfComAddress>");
        }
        sb.append("</Organization></ListOfOrganization>");
        List<ShopContacts> contatses = s.getContactses();
        if (contatses.size() > 0) {
            sb.append("<ListOfContact>");
            for (ShopContacts c : contatses) {
                sb.append("<Contact>");
                if (StringUtils.isEmpty(c.getSiebelContactsId())) {
                    sb.append("<Id>").append(c.getId()).append("</Id>");
                } else {
                    sb.append("<Id>").append(c.getId()).append("</Id>");
                }
                sb.append("<RoleType>").append(c.getDutyTypeName()).append("</RoleType>");
                sb.append("<FullName>").append(c.getContactsName()).append("</FullName>");
                if (StringUtils.isEmpty(c.getOfficePhone())) {
                    sb.append("<PrimaryPhone/>");
                } else {
                    sb.append("<PrimaryPhone>").append(c.getOfficePhone()).append("</PrimaryPhone>");
                }
                sb.append("<PhoneNumber>").append(c.getMobilePhone()).append("</PhoneNumber>");
                sb.append("<OrganizationId>").append(me.getCurrentPartner().getOrganizationid()).append("</OrganizationId>");
                if (StringUtils.isEmpty(c.getFax())) {
                    sb.append("<FaxPhone/>");
                } else {
                    sb.append("<FaxPhone>").append(c.getFax()).append("</FaxPhone>");
                }
                if (StringUtils.isEmpty(c.getQq())) {
                    sb.append("<QQ/>");
                } else {
                    sb.append("<QQ>").append(c.getQq()).append("</QQ>");
                }
                if (StringUtils.isEmpty(c.getEmail())) {
                    sb.append("<Email/>");
                } else {
                    sb.append("<Email>").append(c.getEmail()).append("</Email>");
                }
                if (StringUtils.isEmpty(c.getAddress())) {
                    sb.append("<Address/>");
                } else {
                    sb.append("<Address>").append(c.getAddress()).append("</Address>");
                }
                sb.append("<OrganizationId>").append(me.getCurrentPartner().getOrganizationid()).append("</OrganizationId>");
                if (c.getStartDate() == null) {
                    sb.append("<StartDate></StartDate>");
                } else {
                    sb.append("<StartDate>").append(DateUtils.formartDate((Date)c.getStartDate(), null)).append("</StartDate>");
                }
                if (c.getEndDate() == null) {
                    sb.append("<EndDate></EndDate>");
                } else {
                    sb.append("<EndDate>").append(DateUtils.formartDate((Date)c.getEndDate(), null)).append("</EndDate>");
                }
                sb.append("<IsContactFlg>Y</IsContactFlg><!--\u8054\u7cfb\u4eba\u6807\u8bc6-->");
                sb.append("<CreatorId>").append(c.getCreatorId()).append("</CreatorId>");
                sb.append("<CreateDt>").append(DateUtils.formartDate((Date)c.getCreateDt(), null)).append("</CreateDt>");
                sb.append("<LastUpdatorId>").append(c.getLastUpdatorId()).append("</LastUpdatorId>");
                sb.append("<LastUpdateDt>").append(DateUtils.formartDate((Date)c.getLastUpdateDt(), null)).append("</LastUpdateDt>");
                sb.append("</Contact>");
            }
            sb.append("</ListOfContact>");
        }
        sb.append("</ChannelPartner></ListOfChannelPartner>");
        String xml = sb.toString();
        return xml;
    }
}

