/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.target;

import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Target;
import com.tcbj.crm.target.TargetViewCondition;
import com.tcbj.crm.target.excel.TargetSellerExc;
import com.tcbj.crm.target.excel.TargetViewExc;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TargetViewService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private ClientService clientService;

    public String querystr(TargetViewCondition condition, List<Object> args, String selects, String groupBy) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" select ");
        HQL.append(" sum(t.m1) m1,sum(t.m2) m2,sum(t.m3) m3,sum(t.m4) m4,sum(t.m5) m5,sum(t.m6) m6,sum(t.m7) m7, ");
        HQL.append(" sum(t.m8) m8,sum(t.m9) m9,sum(t.m10) m10,sum(t.m11) m11,sum(t.m12) m12,");
        HQL.append(selects);
        HQL.append("  from CX_TARGET t,CX_AWK_PRTNR_ACCOUNTLIST_VIEW c where ");
        HQL.append(" c.orgid = t.partner_id and c.partnerid = t.object_Id ");
        String regions = this.personnelService.getFRegionsByUserId(condition.getEmployeeId());
        HQL.append(" and ( t.area_id in  (");
        HQL.append(regions);
        HQL.append(" )");
        HQL.append("or t.bigarea_id in(");
        HQL.append(regions);
        HQL.append(") )");
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and t.partner_id=?");
            args.add(condition.getSupplierId());
        }
        if (condition.getYear() != null) {
            HQL.append(" and t.year=?");
            args.add(condition.getYear());
        }
        if (StringUtils.isNotEmpty(condition.getType())) {
            HQL.append(" and t.type=?");
            args.add(condition.getType());
        }
        if (StringUtils.isNotEmpty(condition.getChannelId())) {
            HQL.append(" and t.channel_id=?");
            args.add(condition.getChannelId());
        }
        if (StringUtils.isNotEmpty(condition.getBigareaId())) {
            HQL.append(" and t.bigarea_id=?");
            args.add(condition.getBigareaId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            HQL.append(" and t.area_id=?");
            args.add(condition.getAreaId());
        }
        if (StringUtils.isNotEmpty(condition.getProductType())) {
            HQL.append(" and t.product_type=?");
            args.add(condition.getProductType());
        }
        if (StringUtils.isNotEmpty(condition.getProductSubType())) {
            HQL.append(" and t.product_sub_type=?");
            args.add(condition.getProductSubType());
        }
        if (StringUtils.isNotEmpty(condition.getObjectType())) {
            HQL.append(" and t.object_type=?");
            args.add(condition.getObjectType());
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            HQL.append(" and t.object_id=?");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            String customerName = condition.getCustomerName();
            try {
                customerName = new String(customerName.getBytes("iso8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            HQL.append("and c.partnername like ? ");
            args.add("%" + customerName + "%");
        }
        HQL.append(" group by ");
        HQL.append(groupBy);
        return HQL.toString();
    }

    public String querystrSeller(TargetViewCondition condition, List<Object> args, String selects, String groupBy) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("select ");
        HQL.append(" sum(m1) m1,sum(m2) m2,sum(m3) m3,sum(m4) m4,sum(m5) m5,sum(m6) m6,sum(m7) m7, ");
        HQL.append(" sum(m8) m8,sum(m9) m9,sum(m10) m10,sum(m11) m11,sum(m12) m12,");
        HQL.append(selects);
        HQL.append("  from CX_TARGET t, CX_AWK_PRTNR_CONTACTLIST_VIEW c  where ");
        HQL.append(" c.ROW_ID = t.object_Id ");
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and t.partner_id=?");
            args.add(condition.getSupplierId());
        }
        if (condition.getYear() != null) {
            HQL.append(" and t.year=?");
            args.add(condition.getYear());
        }
        if (StringUtils.isNotEmpty(condition.getType())) {
            HQL.append(" and t.type=?");
            args.add(condition.getType());
        }
        if (StringUtils.isNotEmpty(condition.getObjectType())) {
            HQL.append(" and t.object_type=?");
            args.add(condition.getObjectType());
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            HQL.append(" and t.object_id=?");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getSellerName())) {
            String sellerName = condition.getSellerName();
            try {
                sellerName = new String(sellerName.getBytes("iso8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            HQL.append("and c.FULLNAME like ? ");
            args.add("%" + sellerName + "%");
        }
        HQL.append(" group by ");
        HQL.append(groupBy);
        return HQL.toString();
    }

    public Page targetAllQuery(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> targetAll = new ArrayList<Object>();
        condition.setObjectType("\u5ba2\u6237");
        List org = null;
        List bigArea = null;
        List customer = null;
        List area = null;
        List channel = null;
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            customer = this.getCustomer(condition, pageno, rowsize).getList();
        } else if (StringUtils.isNotEmpty(condition.getAreaId())) {
            area = this.getArea(condition, pageno, rowsize).getList();
        } else if (StringUtils.isNotEmpty(condition.getBigareaId())) {
            bigArea = this.getBigArea(condition, pageno, rowsize).getList();
        } else if (StringUtils.isNotEmpty(condition.getChannelId())) {
            channel = this.getChannel(condition, pageno, rowsize).getList();
        } else {
            org = this.getOrg(condition, pageno, rowsize).getList();
            customer = this.getCustomer(condition, pageno, rowsize).getList();
            channel = this.getChannel(condition, pageno, rowsize).getList();
            bigArea = this.getBigArea(condition, pageno, rowsize).getList();
            area = this.getArea(condition, pageno, rowsize).getList();
        }
        if (org != null) {
            this.putObjToList(targetAll, org);
        }
        if (channel != null) {
            this.putObjToList(targetAll, channel);
        }
        if (bigArea != null) {
            this.putObjToList(targetAll, bigArea);
        }
        if (area != null) {
            this.putObjToList(targetAll, area);
        }
        if (customer != null) {
            this.putObjToList(targetAll, customer);
        }
        Page page = new Page();
        page.setList(targetAll);
        return this.wrap(page, condition.getSupplierId());
    }

    private void putObjToList(List<Object> targetAll, List<?> org) {
        for (Object object : org) {
            targetAll.add(object);
        }
    }

    private Page getOrg(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> args = new ArrayList<Object>();
        condition.setObjectType("\u5ba2\u6237");
        String selects = "t.year, t.type, '' as product_type, '' as product_sub_type";
        String groupBy = "t.year,t.type,t.product_type,t.product_sub_type";
        String hql = this.querystr(condition, args, selects, groupBy);
        return this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
    }

    private Page getArea(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> args = new ArrayList<Object>();
        String selects = "year,type,'' as product_type,'' as product_sub_type,channel_id,bigarea_id,area_id";
        String groupBy = "year,type,product_type,product_sub_type,channel_id,bigarea_id,area_id";
        String hql = this.querystr(condition, args, selects, groupBy);
        return this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
    }

    private Page getBigArea(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> args = new ArrayList<Object>();
        String selects = "year,type,'' as product_type,'' as product_sub_type,channel_id,bigarea_id";
        String groupBy = "year,type,product_type,product_sub_type,channel_id,bigarea_id";
        String hql = this.querystr(condition, args, selects, groupBy);
        return this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
    }

    private Page getChannel(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> args = new ArrayList<Object>();
        String selects = "year,type,'' as product_type,'' as product_sub_type,channel_id";
        String groupBy = "year,type,product_type,product_sub_type,channel_id";
        String hql = this.querystr(condition, args, selects, groupBy);
        return this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
    }

    private Page getCustomer(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> args = new ArrayList<Object>();
        String selects = "year,type,product_type,product_sub_type,channel_id,bigarea_id,area_id,object_type,object_id";
        String groupBy = "year,type,product_type,product_sub_type,channel_id,bigarea_id,area_id,object_type,object_id";
        String hql = this.querystr(condition, args, selects, groupBy);
        return this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null);
    }

    public Page orgQuery(TargetViewCondition condition, int pageno, int rowsize) {
        return this.wrap(this.getOrg(condition, pageno, rowsize), condition.getSupplierId());
    }

    public Page channelQuery(TargetViewCondition condition, int pageno, int rowsize) {
        return this.wrap(this.getChannel(condition, pageno, rowsize), condition.getSupplierId());
    }

    public Page bigareaQuery(TargetViewCondition condition, int pageno, int rowsize) {
        return this.wrap(this.getBigArea(condition, pageno, rowsize), condition.getSupplierId());
    }

    public Page areaQuery(TargetViewCondition condition, int pageno, int rowsize) {
        return this.wrap(this.getArea(condition, pageno, rowsize), condition.getSupplierId());
    }

    public Page sellerQuery(TargetViewCondition condition, int pageno, int rowsize) {
        ArrayList<Object> args = new ArrayList<Object>();
        condition.setObjectType("\u4eba\u5458");
        String selects = "year,type,product_type,product_sub_type,channel_id,bigarea_id,area_id,object_type,object_id";
        String groupBy = "year,type,product_type,product_sub_type,channel_id,bigarea_id,area_id,object_type,object_id";
        String hql = this.querystrSeller(condition, args, selects, groupBy);
        return this.wrap(this.baseDao.searchBySql(hql.toString(), args.toArray(), rowsize, pageno, null), condition.getSupplierId());
    }

    public Page customerQuery(TargetViewCondition condition, int pageno, int rowsize) {
        return this.wrap(this.getCustomer(condition, pageno, rowsize), condition.getSupplierId());
    }

    private Page wrap(Page page, String partnerId) {
        List list = page.getList();
        ArrayList<Target> targets = new ArrayList<Target>();
        for (Object tmp : list) {
            Object[] obj = (Object[])tmp;
            Target target = new Target();
            if (obj[0] != null) {
                target.setM1(((BigDecimal)obj[0]).doubleValue());
            }
            if (obj[1] != null) {
                target.setM2(((BigDecimal)obj[1]).doubleValue());
            }
            if (obj[2] != null) {
                target.setM3(((BigDecimal)obj[2]).doubleValue());
            }
            if (obj[3] != null) {
                target.setM4(((BigDecimal)obj[3]).doubleValue());
            }
            if (obj[4] != null) {
                target.setM5(((BigDecimal)obj[4]).doubleValue());
            }
            if (obj[5] != null) {
                target.setM6(((BigDecimal)obj[5]).doubleValue());
            }
            if (obj[6] != null) {
                target.setM7(((BigDecimal)obj[6]).doubleValue());
            }
            if (obj[7] != null) {
                target.setM8(((BigDecimal)obj[7]).doubleValue());
            }
            if (obj[8] != null) {
                target.setM9(((BigDecimal)obj[8]).doubleValue());
            }
            if (obj[9] != null) {
                target.setM10(((BigDecimal)obj[9]).doubleValue());
            }
            if (obj[10] != null) {
                target.setM11(((BigDecimal)obj[10]).doubleValue());
            }
            if (obj[11] != null) {
                target.setM12(((BigDecimal)obj[11]).doubleValue());
            }
            if (obj.length > 12 && obj[12] != null) {
                target.setYear(((BigDecimal)obj[12]).longValue());
            }
            if (obj.length > 13 && obj[13] != null) {
                target.setType((String)obj[13]);
            }
            if (obj.length > 14 && obj[14] != null) {
                target.setProductType((String)obj[14]);
            }
            if (obj.length > 15 && obj[15] != null) {
                target.setProductSubType((String)obj[15]);
            }
            if (obj.length > 16 && obj[16] != null) {
                target.setChannelId((String)obj[16]);
            }
            if (obj.length > 17 && obj[17] != null) {
                target.setBigareaId((String)obj[17]);
            }
            if (obj.length > 18 && obj[18] != null) {
                target.setAreaId((String)obj[18]);
            }
            if (obj.length > 19 && obj[19] != null) {
                target.setObjectType((String)obj[19]);
            }
            if (obj.length > 20 && obj[20] != null) {
                target.setObjectId((String)obj[20]);
            }
            target.setPartnerId(partnerId);
            targets.add(target);
        }
        page.setList(targets);
        return page;
    }

    public List<TargetViewExc> getTargetAllExcelData(TargetViewCondition con, int pageNo, int rowsize) {
        Page page = this.targetAllQuery(con, pageNo, rowsize);
        ArrayList<TargetViewExc> targetView = new ArrayList<TargetViewExc>();
        List list = page.getList();
        for (Object obj : list) {
            if (!(obj instanceof Target)) continue;
            Target t = (Target)obj;
            TargetViewExc excel = new TargetViewExc();
            excel.setTypeName(t.getTypeName());
            excel.setYear(t.getYear().toString());
            excel.setUnitName(t.getUnitName());
            excel.setChannelName(t.getChannelName());
            excel.setBigareaName(t.getBigAreaName());
            excel.setAreaName(t.getAreaName());
            excel.setCustomerName(t.getCustomerName());
            excel.setProductTypeName(t.getProductTypeName());
            excel.setProductSubTypeName(t.getProductSubTypeName());
            excel.setTotal(t.getY().toString());
            excel.setM1(t.getM1().toString());
            excel.setM2(t.getM2().toString());
            excel.setM3(t.getM3().toString());
            excel.setM4(t.getM4().toString());
            excel.setM5(t.getM5().toString());
            excel.setM6(t.getM6().toString());
            excel.setM7(t.getM7().toString());
            excel.setM8(t.getM8().toString());
            excel.setM9(t.getM9().toString());
            excel.setM10(t.getM10().toString());
            excel.setM11(t.getM11().toString());
            excel.setM12(t.getM12().toString());
            targetView.add(excel);
        }
        return targetView;
    }

    public List<TargetSellerExc> getSellerTargetExcelData(TargetViewCondition con, int pageNo, int rowsize) {
        Page page = this.sellerQuery(con, pageNo, rowsize);
        ArrayList<TargetSellerExc> sellerTarget = new ArrayList<TargetSellerExc>();
        List list = page.getList();
        for (Object object : list) {
            if (!(object instanceof Target)) continue;
            Target t = (Target)object;
            TargetSellerExc excel = new TargetSellerExc();
            excel.setTypeName(t.getTypeName());
            excel.setUnitName(t.getUnitName());
            excel.setSellerName(t.getEmployeeName());
            excel.setProductTypeName(t.getProductTypeName());
            excel.setProductSubTypeName(t.getProductSubTypeName());
            excel.setTotal(t.getY().toString());
            excel.setM1(t.getM1().toString());
            excel.setM2(t.getM2().toString());
            excel.setM3(t.getM3().toString());
            excel.setM4(t.getM4().toString());
            excel.setM5(t.getM5().toString());
            excel.setM6(t.getM6().toString());
            excel.setM7(t.getM7().toString());
            excel.setM8(t.getM8().toString());
            excel.setM9(t.getM9().toString());
            excel.setM10(t.getM10().toString());
            excel.setM11(t.getM11().toString());
            excel.setM12(t.getM12().toString());
            sellerTarget.add(excel);
        }
        return sellerTarget;
    }

    public Page findCustomerTargetBySeller(TargetViewCondition con, int pageno, int rowsize) {
        con.setObjectType("\u5ba2\u6237");
        StringBuilder hql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        hql.append("select t.* from Target t,TargetSplit tp where ");
        hql.append(" t.objectId = tp.userId ");
        if (StringUtils.isNotEmpty(con.getObjectType())) {
            hql.append(" t.objectType = ? ");
            params.add(con.getObjectType());
        }
        if (con.getYear() != null) {
            hql.append(" t.year = ? ");
            params.add(con.getYear());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql.append(" t.type = ? ");
            params.add(con.getType());
        }
        if (StringUtils.isNotEmpty(con.getObjectId())) {
            hql.append(" t.objectId = ? ");
            params.add(con.getObjectId());
        }
        return this.baseDao.search(hql.toString(), params.toArray(), rowsize, pageno);
    }
}

