/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetdatae;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.entity.TargeteOver;
import com.tcbj.crm.targetdata.TargetDataService;
import com.tcbj.crm.targetdatae.TargetDataeCondition;
import com.tcbj.crm.targetover.TargeteOverCondition;
import com.tcbj.crm.targetover.TargeteOverService;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.ProductCategory;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetDataeService")
public class TargetDataeService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    EmployeeService service;
    @Autowired
    TargeteOverService targeteOverService;
    @Autowired
    TargetDataService targetDataService;

    public TargetData get(String id) {
        return (TargetData)this.baseDao.get(TargetData.class, (Serializable)((Object)id));
    }

    public List<TargetData> getList(String supplierId, Long year) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from TargetData o where o.supplierId = ? and o.year = ? ");
        return this.baseDao.findEntity(hql.toString(), new Object[]{supplierId, year}, TargetData.class);
    }

    public List<TargetData> getList(String type, String supplierId, String applyerId, Long year) {
        StringBuffer hql = new StringBuffer(" from TargetData o where o.userId <> null ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(type)) {
            hql.append(" and o.type = ?");
            args.add(type);
        }
        if (StringUtils.isNotEmpty(supplierId)) {
            hql.append(" and o.supplierId = ?");
            args.add(supplierId);
        }
        if (StringUtils.isNotNull(year)) {
            hql.append(" and o.year = ?");
            args.add(year);
        }
        if (StringUtils.isNotEmpty(applyerId)) {
            hql.append(" and o.applyerId = ?");
            args.add(applyerId);
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), TargetData.class);
    }

    public void save(TargetData obj) {
        this.baseDao.save((Object)obj);
    }

    public void update(TargetData obj) {
        this.baseDao.update((Object)obj);
    }

    public void update(String hql) {
        this.baseDao.executeHQL(hql);
    }

    public void delete(String id) {
        this.baseDao.deleteById(TargetData.class, (Serializable)((Object)id));
    }

    public List<TargetData> getList(TargetDataeCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o.userId,o.year,sum(o.m1),sum(o.m2),sum(o.m3),sum(o.m4),sum(o.m5),sum(o.m6),sum(o.m7),sum(o.m8),sum(o.m9),sum(o.m10),sum(o.m11),sum(o.m12),o.type,o.productType,o.productSubType from TargetData o where o.supplierId = ? and o.userId <> null ");
        args.add(condition.getPartnerId());
        if (StringUtils.isNotEmpty(condition.getUserId())) {
            hql.append(" and o.userId = ? ");
            args.add(condition.getUserId());
        }
        if (StringUtils.isNotNull(condition.getYear())) {
            hql.append(" and o.year = ? ");
            args.add(condition.getYear());
        }
        hql.append(" group by o.userId,o.year,o.type,o.productType,o.productSubType order by o.year desc");
        List objs = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<TargetData> list = new ArrayList<TargetData>();
        TargetData dataE = null;
        for (Object[] object : objs) {
            dataE = new TargetData();
            Object[] obj = new Object[14];
            obj = object;
            dataE.setUserId((String)obj[0]);
            dataE.setYear((Long)obj[1]);
            dataE.setM1((Double)obj[2]);
            dataE.setM2((Double)obj[3]);
            dataE.setM3((Double)obj[4]);
            dataE.setM4((Double)obj[5]);
            dataE.setM5((Double)obj[6]);
            dataE.setM6((Double)obj[7]);
            dataE.setM7((Double)obj[8]);
            dataE.setM8((Double)obj[9]);
            dataE.setM9((Double)obj[10]);
            dataE.setM10((Double)obj[11]);
            dataE.setM11((Double)obj[12]);
            dataE.setM12((Double)obj[13]);
            dataE.setType((String)obj[14]);
            dataE.setProductType((String)obj[15]);
            dataE.setProductSubType((String)obj[16]);
            list.add(dataE);
        }
        return list;
    }

    public Page getPage(String orgid, int pageno, TargetDataeCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("from TargetData o where o.supplierId = ? and o.userId <> null ");
        args.add(condition.getPartnerId());
        if (StringUtils.isNotEmpty(condition.getUserId())) {
            hql.append(" and o.userId = ? ");
            args.add(condition.getUserId());
        }
        if (StringUtils.isNotNull(condition.getYear())) {
            hql.append(" and o.year = ? ");
            args.add(condition.getYear());
        }
        if (StringUtils.isNotEmpty(condition.getType())) {
            hql.append(" and o.type = ? ");
            args.add(condition.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
    }

    public void delete(TargetData targetData) {
        List<TargeteOver> targeteOvers = this.findTargeteOver(targetData.getApplyerId(), targetData.getYear(), targetData.getSupplierId(), targetData.getType());
        for (TargeteOver targeteOver : targeteOvers) {
            TargetData Data = this.findTargetDataUser(targetData.getType(), targetData.getYear(), targeteOver.getUserId(), targetData.getProductType(), targetData.getProductSubType());
            if (Data == null) continue;
            Data.setM1(Data.getM1() - targeteOver.getM1() * targetData.getM1() / 100.0);
            Data.setM2(Data.getM2() - targeteOver.getM2() * targetData.getM2() / 100.0);
            Data.setM3(Data.getM3() - targeteOver.getM3() * targetData.getM3() / 100.0);
            Data.setM4(Data.getM4() - targeteOver.getM4() * targetData.getM4() / 100.0);
            Data.setM5(Data.getM5() - targeteOver.getM5() * targetData.getM5() / 100.0);
            Data.setM6(Data.getM6() - targeteOver.getM6() * targetData.getM6() / 100.0);
            Data.setM7(Data.getM7() - targeteOver.getM7() * targetData.getM7() / 100.0);
            Data.setM8(Data.getM8() - targeteOver.getM8() * targetData.getM8() / 100.0);
            Data.setM9(Data.getM9() - targeteOver.getM9() * targetData.getM9() / 100.0);
            Data.setM10(Data.getM10() - targeteOver.getM10() * targetData.getM10() / 100.0);
            Data.setM11(Data.getM11() - targeteOver.getM11() * targetData.getM11() / 100.0);
            Data.setM12(Data.getM12() - targeteOver.getM12() * targetData.getM12() / 100.0);
            this.baseDao.update((Object)Data);
        }
    }

    private List<TargeteOver> findTargeteOver(String partnerId, Long year, String orgId, String type) {
        TargeteOverCondition con = new TargeteOverCondition();
        con.setPartnerId(partnerId);
        con.setYear(String.valueOf(year));
        con.setOrgId(orgId);
        con.setType(type);
        return this.targeteOverService.getTargetSplits(con);
    }

    public void add(List<TargetData> lists, Employee me) {
        List<Object> targeteOvers = new ArrayList();
        TargetData dataE = null;
        for (TargetData targetData : lists) {
            TargetData oldData = this.targetDataService.findTargetData(targetData.getType(), targetData.getYear(), targetData.getApplyerId(), targetData.getProductType(), targetData.getProductSubType());
            targeteOvers = this.findTargeteOver(targetData.getApplyerId(), targetData.getYear(), me.getCurrentPartner().getId(), targetData.getType());
            for (TargeteOver targeteOver : targeteOvers) {
                TargetData oldUserData = this.findTargetDataUser(targetData.getType(), (long)targetData.getYear(), targeteOver.getUserId(), targetData.getProductType(), targetData.getProductSubType());
                dataE = new TargetData();
                if (StringUtils.isNull(oldUserData)) {
                    dataE.setType(targetData.getType());
                    dataE.setYear(targetData.getYear());
                    dataE.setUserId(targeteOver.getUserId());
                    dataE.setApplyerId(targeteOver.getPartnerId());
                    dataE.setProductType(targetData.getProductType());
                    dataE.setProductSubType(targetData.getProductSubType());
                    dataE.setM1(targetData.getM1() * targeteOver.getM1() / 100.0);
                    dataE.setM2(targetData.getM2() * targeteOver.getM2() / 100.0);
                    dataE.setM3(targetData.getM3() * targeteOver.getM3() / 100.0);
                    dataE.setM4(targetData.getM4() * targeteOver.getM4() / 100.0);
                    dataE.setM5(targetData.getM5() * targeteOver.getM5() / 100.0);
                    dataE.setM6(targetData.getM6() * targeteOver.getM6() / 100.0);
                    dataE.setM7(targetData.getM7() * targeteOver.getM7() / 100.0);
                    dataE.setM8(targetData.getM8() * targeteOver.getM8() / 100.0);
                    dataE.setM9(targetData.getM9() * targeteOver.getM9() / 100.0);
                    dataE.setM10(targetData.getM10() * targeteOver.getM10() / 100.0);
                    dataE.setM11(targetData.getM11() * targeteOver.getM11() / 100.0);
                    dataE.setM12(targetData.getM12() * targeteOver.getM12() / 100.0);
                    dataE.setSupplierId(me.getCurrentPartner().getId());
                    dataE.fillInitData(me);
                    this.baseDao.save((Object)dataE);
                    continue;
                }
                if (oldData != null) {
                    oldUserData.setM1(oldUserData.getM1() - oldData.getM1() * targeteOver.getM1() / 100.0 + targetData.getM1() * targeteOver.getM1() / 100.0);
                    oldUserData.setM2(oldUserData.getM2() - oldData.getM2() * targeteOver.getM2() / 100.0 + targetData.getM2() * targeteOver.getM2() / 100.0);
                    oldUserData.setM3(oldUserData.getM3() - oldData.getM3() * targeteOver.getM3() / 100.0 + targetData.getM3() * targeteOver.getM3() / 100.0);
                    oldUserData.setM4(oldUserData.getM4() - oldData.getM4() * targeteOver.getM4() / 100.0 + targetData.getM4() * targeteOver.getM4() / 100.0);
                    oldUserData.setM5(oldUserData.getM5() - oldData.getM5() * targeteOver.getM5() / 100.0 + targetData.getM5() * targeteOver.getM5() / 100.0);
                    oldUserData.setM6(oldUserData.getM6() - oldData.getM6() * targeteOver.getM6() / 100.0 + targetData.getM6() * targeteOver.getM6() / 100.0);
                    oldUserData.setM7(oldUserData.getM7() - oldData.getM7() * targeteOver.getM7() / 100.0 + targetData.getM7() * targeteOver.getM7() / 100.0);
                    oldUserData.setM8(oldUserData.getM8() - oldData.getM8() * targeteOver.getM8() / 100.0 + targetData.getM8() * targeteOver.getM8() / 100.0);
                    oldUserData.setM9(oldUserData.getM9() - oldData.getM9() * targeteOver.getM9() / 100.0 + targetData.getM9() * targeteOver.getM9() / 100.0);
                    oldUserData.setM10(oldUserData.getM10() - oldData.getM10() * targeteOver.getM10() / 100.0 + targetData.getM10() * targeteOver.getM10() / 100.0);
                    oldUserData.setM11(oldUserData.getM11() - oldData.getM11() * targeteOver.getM11() / 100.0 + targetData.getM11() * targeteOver.getM11() / 100.0);
                    oldUserData.setM12(oldUserData.getM12() - oldData.getM12() * targeteOver.getM12() / 100.0 + targetData.getM12() * targeteOver.getM12() / 100.0);
                } else {
                    oldUserData.setM1(oldUserData.getM1() + targetData.getM1() * targeteOver.getM1() / 100.0);
                    oldUserData.setM2(oldUserData.getM2() + targetData.getM2() * targeteOver.getM2() / 100.0);
                    oldUserData.setM3(oldUserData.getM3() + targetData.getM3() * targeteOver.getM3() / 100.0);
                    oldUserData.setM4(oldUserData.getM4() + targetData.getM4() * targeteOver.getM4() / 100.0);
                    oldUserData.setM5(oldUserData.getM5() + targetData.getM5() * targeteOver.getM5() / 100.0);
                    oldUserData.setM6(oldUserData.getM6() + targetData.getM6() * targeteOver.getM6() / 100.0);
                    oldUserData.setM7(oldUserData.getM7() + targetData.getM7() * targeteOver.getM7() / 100.0);
                    oldUserData.setM8(oldUserData.getM8() + targetData.getM8() * targeteOver.getM8() / 100.0);
                    oldUserData.setM9(oldUserData.getM9() + targetData.getM9() * targeteOver.getM9() / 100.0);
                    oldUserData.setM10(oldUserData.getM10() + targetData.getM10() * targeteOver.getM10() / 100.0);
                    oldUserData.setM11(oldUserData.getM11() + targetData.getM11() * targeteOver.getM11() / 100.0);
                    oldUserData.setM12(oldUserData.getM12() + targetData.getM12() * targeteOver.getM12() / 100.0);
                }
                this.baseDao.update((Object)oldUserData);
            }
        }
    }

    public void update(List<TargetData> targetDatas, String delIds, Employee me) {
        try {
            String[] ids;
            String[] stringArray = ids = delIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    this.baseDao.executeHQL("delete TargetData where id= ?", args);
                }
                ++n2;
            }
            for (TargetData targetData : targetDatas) {
                targetData.fillInitData(me);
                targetData.setApplyerId(me.getCurrentPartner().getId());
                targetData.setSupplierId(me.getCurrentPartner().getId());
                if (StringUtils.isEmpty(targetData.getId())) {
                    this.baseDao.save((Object)targetData);
                    continue;
                }
                this.baseDao.update((Object)targetData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveOrUpdate(List<TargetData> list, String supplierId, Long year) {
        HashMap<String, TargetData> map = new HashMap<String, TargetData>();
        this.initMap(map, supplierId, year);
        TargetData t1 = null;
        TargetData t2 = null;
        int k = 0;
        while (k < list.size()) {
            String updateHql = "";
            t1 = list.get(k);
            String s1 = String.valueOf(t1.getType()) + t1.getYear().toString() + t1.getUserId() + t1.getProductType() + t1.getProductSubType();
            if (map.get(s1) == null) {
                this.baseDao.save((Object)t1);
            } else {
                t2 = (TargetData)map.get(s1);
                if (!(updateHql = String.valueOf(updateHql) + this.addHql(t1, t2)).equals("")) {
                    this.baseDao.executeHQL(updateHql);
                }
            }
            ++k;
        }
    }

    private String addHql(TargetData t1, TargetData t2) {
        StringBuffer hql = new StringBuffer("");
        String hql2 = "";
        boolean change = false;
        if (Double.compare(t1.getM1(), t2.getM1()) != 0) {
            hql.append(" m1 = '").append(t1.getM1()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM2(), t2.getM2()) != 0) {
            hql.append(" m2 = '").append(t1.getM2()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM3(), t2.getM3()) != 0) {
            hql.append(" m3 = '").append(t1.getM3()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM4(), t2.getM4()) != 0) {
            hql.append(" m4 = '").append(t1.getM4()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM5(), t2.getM5()) != 0) {
            hql.append(" m5 = '").append(t1.getM5()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM6(), t2.getM6()) != 0) {
            hql.append(" m6 = '").append(t1.getM6()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM7(), t2.getM7()) != 0) {
            hql.append(" m7 = '").append(t1.getM7()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM8(), t2.getM8()) != 0) {
            hql.append(" m8 = '").append(t1.getM8()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM9(), t2.getM9()) != 0) {
            hql.append(" m9 = '").append(t1.getM9()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM10(), t2.getM10()) != 0) {
            hql.append(" m10 = '").append(t1.getM10()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM11(), t2.getM11()) != 0) {
            hql.append(" m11 = '").append(t1.getM11()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM12(), t2.getM12()) != 0) {
            hql.append(" m12 = '").append(t1.getM12()).append("',");
            change = true;
        }
        if (change) {
            hql2 = "update TargetData set ";
            hql2 = String.valueOf(hql2) + hql.toString().substring(0, hql.toString().length() - 1);
            hql2 = String.valueOf(hql2) + " where id = '" + t2.getId() + "'";
        }
        return hql2;
    }

    private void initMap(Map<String, TargetData> map, String supplierId, Long year) {
        List<TargetData> datas = this.getList(supplierId, year);
        for (TargetData t1 : datas) {
            map.put(String.valueOf(t1.getType()) + t1.getYear().toString() + t1.getUserId() + t1.getProductType() + t1.getProductSubType(), t1);
        }
    }

    private Map<String, String> getPartnerContactMap(String parentId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<PartnerContact> list = this.service.find(parentId);
        for (PartnerContact partnerContact : list) {
            map.put(partnerContact.getContactName(), partnerContact.getId());
        }
        return map;
    }

    public List<AdjustStockUtil> validate(Long year, List<List<Object>> readExcelList, Employee emp, List<TargetData> list) {
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        Map<String, String> partnerContactMap = this.getPartnerContactMap(emp.getCurrentPartner().getId());
        List<DictionaryItem> items = Cache.getItems("TCBJ_PACT_TARGET_TYPE");
        HashMap<String, String> itemsMap = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : items) {
            itemsMap.put(dictionaryItem.getVal(), dictionaryItem.getName());
        }
        List pcs = this.baseDao.findEntity("from ProductCategory", ProductCategory.class);
        HashMap<String, String> pcsMap = new HashMap<String, String>();
        for (ProductCategory productCategory : pcs) {
            pcsMap.put(productCategory.getName(), productCategory.getId());
        }
        int j = 0;
        while (j < readExcelList.size()) {
            List<Object> data = readExcelList.get(j);
            String result = null;
            String message = null;
            TargetData targetData = new TargetData();
            int i = 0;
            while (i < data.size()) {
                switch (i) {
                    case 0: {
                        message = ValidataUtils.validataMap((Object)data.get(i), itemsMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u76ee\u6807\u7c7b\u578b \uff1a" + message;
                            break;
                        }
                        targetData.setType((String)itemsMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 1: {
                        targetData.setYear(year);
                        break;
                    }
                    case 2: {
                        message = ValidataUtils.validataMap((Object)data.get(i), partnerContactMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4eba\u5458 \uff1a" + message;
                            break;
                        }
                        targetData.setUserId(partnerContactMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 3: {
                        message = ValidataUtils.validateMapOrNull((Object)data.get(i), pcsMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ea7\u54c1\u7c7b\u522b \uff1a" + message;
                            break;
                        }
                        targetData.setProductType(pcsMap.get(data.get(i).toString().trim()) == null ? "" : (String)pcsMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 4: {
                        message = ValidataUtils.validateMapOrNull((Object)data.get(i), pcsMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ea7\u54c1\u5b50\u7c7b\u522b \uff1a" + message;
                            break;
                        }
                        targetData.setProductSubType(pcsMap.get(data.get(i).toString().trim()) == null ? "" : (String)pcsMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 5: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 1\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM1(this.toDouble(data.get(i)));
                        break;
                    }
                    case 6: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 2\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM2(this.toDouble(data.get(i)));
                        break;
                    }
                    case 7: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 3\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM3(this.toDouble(data.get(i)));
                        break;
                    }
                    case 8: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 4\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM4(this.toDouble(data.get(i)));
                        break;
                    }
                    case 9: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 5\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM5(this.toDouble(data.get(i)));
                        break;
                    }
                    case 10: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 6\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM6(this.toDouble(data.get(i)));
                        break;
                    }
                    case 11: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 7\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM7(this.toDouble(data.get(i)));
                        break;
                    }
                    case 12: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 8\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM8(this.toDouble(data.get(i)));
                        break;
                    }
                    case 13: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 9\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM9(this.toDouble(data.get(i)));
                        break;
                    }
                    case 14: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 10\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM10(this.toDouble(data.get(i)));
                        break;
                    }
                    case 15: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 11\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM11(this.toDouble(data.get(i)));
                        break;
                    }
                    case 16: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 12\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM12(this.toDouble(data.get(i)));
                        break;
                    }
                }
                targetData.setApplyerId(emp.getCurrentPartner().getId());
                targetData.setSupplierId(emp.getCurrentPartner().getId());
                ++i;
            }
            if (result != null) {
                msglist.add(new AdjustStockUtil("\u7b2c" + (j + 2) + "\u884c:" + result));
            }
            list.add(targetData);
            ++j;
        }
        TargetData t1 = null;
        TargetData t2 = null;
        String s1 = null;
        String s2 = null;
        int k = 0;
        while (k < list.size()) {
            t1 = list.get(k);
            s1 = String.valueOf(t1.getType()) + (t1.getYear() == null ? "0" : t1.getYear().toString()) + t1.getUserId() + t1.getProductType() + t1.getProductSubType();
            int k2 = k + 1;
            while (k2 < list.size()) {
                t2 = list.get(k2);
                s2 = String.valueOf(t2.getType()) + (t2.getYear() == null ? "0" : t2.getYear().toString()) + t2.getUserId() + t2.getProductType() + t2.getProductSubType();
                if (s1.equals(s2)) {
                    msglist.add(new AdjustStockUtil("\u7b2c" + (k + 1) + "\u548c" + (k2 + 1) + "\u884c\u6570\u636e\u91cd\u590d"));
                }
                ++k2;
            }
            ++k;
        }
        return msglist;
    }

    private Double toDouble(Object object) {
        return Double.parseDouble(String.valueOf(object).trim() == null || "".equals(String.valueOf(object).trim()) ? "0" : String.valueOf(object).trim());
    }

    private String vaildataNull(Double db) {
        if (db == null) {
            return "0";
        }
        return String.valueOf(db);
    }

    public TargetData findTargetDataUser(String type, Long year, String userId, String productType, String productSubType) {
        StringBuffer sb = new StringBuffer("from TargetData where type = ? and year = ? and userId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(type);
        args.add(year);
        args.add(userId);
        if (StringUtils.isNotEmpty(productType)) {
            sb.append(" and productType = ? ");
            args.add(productType);
        } else {
            sb.append(" and productType is null ");
        }
        if (StringUtils.isNotEmpty(productSubType)) {
            sb.append(" and productSubType = ? ");
            args.add(productSubType);
        } else {
            sb.append(" and productSubType is null ");
        }
        return (TargetData)this.baseDao.findFirstEntity(sb.toString(), args.toArray(), TargetData.class);
    }

    public boolean excel(List<TargetData> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5e74\u4efd", "\u4eba\u5458", "\u4ea7\u54c1\u7c7b\u578b", "\u4ea7\u54c1\u5b50\u7c7b\u578b", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            TargetData stu = list.get(i);
            String[] vals = new String[]{stu.getTypeName(), String.valueOf(stu.getYear()), stu.getUserName(), stu.getProductTypeName(), stu.getProductSubTypeName(), this.vaildataNull(stu.getM1()), this.vaildataNull(stu.getM2()), this.vaildataNull(stu.getM3()), this.vaildataNull(stu.getM4()), this.vaildataNull(stu.getM5()), this.vaildataNull(stu.getM6()), this.vaildataNull(stu.getM7()), this.vaildataNull(stu.getM8()), this.vaildataNull(stu.getM9()), this.vaildataNull(stu.getM10()), this.vaildataNull(stu.getM11()), this.vaildataNull(stu.getM12())};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

