/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetmanage;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.TargetManage;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.targetmanage.TargetManageCondition;
import com.tcbj.crm.targetmanage.TargetManageService;
import com.tcbj.framework.util.Page;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/targetmanage"})
public class TargetManageController
extends BaseController {
    @Autowired
    TargetManageService targetManagetService;

    @RequestMapping(value={"budgetList.do"})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, TargetManageCondition con, Model model) {
        Page page = this.targetManagetService.getPages(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "targetmanage/budgetList.ftl";
    }

    @RequestMapping(value={"/budgetAdd.do"}, method={RequestMethod.GET})
    public String add_get(TargetManage targetManage, Model model) {
        model.addAttribute("targetManage", (Object)targetManage);
        return "targetmanage/budgetAdd.ftl";
    }

    @RequestMapping(value={"/budgetAdd.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody TargetManage targetManage, Model model, HttpServletRequest request) {
        boolean isExist = this.targetManagetService.isExist(targetManage.getManagetTarget(), targetManage.getManageType(), null);
        if (isExist) {
            throw new AppException("5120");
        }
        targetManage.fillInitData(this.getCurrentEmployee());
        this.targetManagetService.save(targetManage);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/budgetEdit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model) {
        TargetManage targetManage = this.targetManagetService.getById(id);
        model.addAttribute("targetManage", (Object)targetManage);
        return "targetmanage/budgetEdit.ftl";
    }

    @RequestMapping(value={"/budgetEdit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody TargetManage targetManage, Model model, HttpServletRequest request) {
        boolean isExist = this.targetManagetService.isExist(targetManage.getManagetTarget(), targetManage.getManageType(), targetManage.getId());
        if (isExist) {
            throw new AppException("5120");
        }
        targetManage.fillInitData(this.getCurrentEmployee());
        this.targetManagetService.update(targetManage);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/budgetView.do"}, method={RequestMethod.GET})
    public String view(String id, Model model) {
        TargetManage targetManage = this.targetManagetService.getById(id);
        model.addAttribute("targetManage", (Object)targetManage);
        return "targetmanage/budgetView.ftl";
    }

    @RequestMapping(value={"del.do"})
    public String del(String id, Model model) {
        TargetManage targetManage = this.targetManagetService.getById(id);
        targetManage.setState("9");
        this.targetManagetService.update(targetManage);
        return "redirect:budgetList.do";
    }
}

