/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetrate;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.TargetRate;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.targetrate.TargetRateCondition;
import com.tcbj.crm.targetrate.TargetRateService;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/targetrate"})
public class TargetRateController
extends BaseController {
    @Autowired
    TargetRateService targetRateService;

    @RequestMapping(value={"/list.do"})
    public String get_list(String returnYear, TargetRateCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        Calendar c = Calendar.getInstance();
        int newYear = c.get(1);
        ArrayList<Integer> args = new ArrayList<Integer>();
        int i = (newYear += 10) - 20;
        while (i <= newYear) {
            args.add(i);
            ++i;
        }
        if (StringUtils.isNotNull(returnYear)) {
            con.setYear(Long.valueOf(returnYear));
        } else {
            con.setYear(new Long(c.get(1)));
        }
        con.setPartnerId(em.getCurrentPartner().getId());
        List<TargetRate> targetRateList = this.targetRateService.getList(con);
        for (TargetRate targetRate : targetRateList) {
            targetRate.setCollect(String.valueOf(targetRate.getM1() + targetRate.getM2() + targetRate.getM3() + targetRate.getM4() + targetRate.getM5() + targetRate.getM6() + targetRate.getM7() + targetRate.getM8() + targetRate.getM9() + targetRate.getM10() + targetRate.getM11() + targetRate.getM12()));
        }
        model.addAttribute("TargetRateS", (Object)JSON.toJSONString(targetRateList));
        model.addAttribute("args", args);
        model.addAttribute("con", (Object)con);
        return "targetrate/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody TargetRateCondition targetRateCondition, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee em = this.getCurrentEmployee();
        if (StringUtils.isNotEmpty(targetRateCondition.getDelIds())) {
            String[] stringArray = targetRateCondition.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.targetRateService.delete(id);
                ++n2;
            }
        }
        List<TargetRate> targetRates = targetRateCondition.getTargetRates();
        for (TargetRate targetRate : targetRates) {
            boolean isExist = this.targetRateService.isExist(em.getCurrentPartner().getId(), targetRateCondition.getYear(), targetRate.getSaleChannel(), targetRate.getTarget(), targetRate.getId());
            if (!isExist) continue;
            throw new AppException("5115");
        }
        this.targetRateService.update(targetRateCondition, em);
        return this.getSuccessResult(targetRateCondition.getYear());
    }
}

