/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.trainapply;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.competition.CompetitionService;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.entity.TrainApply;
import com.tcbj.crm.trainapply.ApplyService;
import com.tcbj.crm.trainapply.TrainApplyCondition;
import com.tcbj.crm.trainapply.TrainApplyService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/trainapply"})
public class TrainApplyController
extends BaseController {
    @Autowired
    TrainApplyService trainApplyService;
    @Autowired
    CompetitionService competitionService;
    @Autowired
    ApplyService applyService;

    @RequestMapping(value={"/list.do"})
    public String get_list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, TrainApplyCondition con, Model model) {
        Employee em = this.getCurrentEmployee();
        con.setApplyerId(em.getId());
        Page page = this.trainApplyService.getPage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "trainapply/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(TrainApply trainApply, Model model) {
        Employee em = this.getCurrentEmployee();
        model.addAttribute("trainApply", (Object)trainApply);
        model.addAttribute("applyer", (Object)em.getName());
        model.addAttribute("applyerId", (Object)em.getId());
        model.addAttribute("date", (Object)DateUtils.now());
        return "trainapply/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String add_post(TrainApply trainApply, String state, Model model, HttpServletRequest request) throws AxisFault {
        Employee em = this.getCurrentEmployee();
        String rtn = null;
        List<IUploadFile> filelist = this.uploadFile(request, "trainapply");
        trainApply.fillInitData(em);
        trainApply.setState(state);
        this.trainApplyService.save(trainApply, filelist, em);
        this.applyService.addTrainApply(trainApply);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model) {
        TrainApply trainApply = this.trainApplyService.getById(id);
        List<ShoppeApplyFile> shoppeApplyFile = this.competitionService.getShoppeApplyFile(trainApply.getId());
        model.addAttribute("shoppeApplyFile", shoppeApplyFile);
        model.addAttribute("trainApply", (Object)trainApply);
        return "trainapply/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.POST})
    public String edit_post(TrainApply trainApply, BindingResult errors, TrainApplyCondition con, Model model, HttpServletRequest request) {
        String rtn = null;
        trainApply.fillInitData(this.getCurrentEmployee());
        List<IUploadFile> filelist = this.uploadFile(request, "trainapply");
        this.trainApplyService.update(trainApply, filelist, con, this.getCurrentEmployee());
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, Model model) {
        TrainApply trainApply = this.trainApplyService.getById(id);
        List<ShoppeApplyFile> shoppeApplyFile = this.competitionService.getShoppeApplyFile(trainApply.getId());
        model.addAttribute("shoppeApplyFile", shoppeApplyFile);
        model.addAttribute("trainApply", (Object)trainApply);
        return "trainapply/view.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(String id, Model model) {
        TrainApply trainApply = this.trainApplyService.getById(id);
        trainApply.setState("9");
        this.trainApplyService.update(trainApply, null, null, null);
        return "redirect:list.do";
    }

    @RequestMapping(value={"/delete.do"})
    public String delete(String id, Model model) {
        this.trainApplyService.delete(id);
        return "redirect:list.do";
    }
}

