/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.util;

import com.tcbj.crm.util.PropertyManager;
import com.tcbj.util.Beans;
import com.tcbj.util.Https;
import com.tcbj.util.Jsons;
import java.util.HashMap;
import java.util.Map;

public class EasRequestHelper {
    private static String token;
    private static final String SUCCESS = "00";
    private static final String TOKEN_EXPIRE = "99";
    private static EasRequestHelper helper;

    private EasRequestHelper() {
        EasRequestHelper.initToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static EasRequestHelper getInstance() {
        if (helper == null) {
            Class<EasRequestHelper> clazz = EasRequestHelper.class;
            // MONITORENTER : com.tcbj.crm.util.EasRequestHelper.class
            helper = new EasRequestHelper();
            // MONITOREXIT : clazz
        }
        if (!Beans.isEmpty((Object)token)) return helper;
        EasRequestHelper.initToken();
        return helper;
    }

    private static synchronized void initToken() {
        String url = PropertyManager.getProperty("eas_token_url_post");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appId", "easapp");
        param.put("appSecret", "123easappsecretcode456");
        String response = Https.getInstance().post(url, param);
        if (Beans.isEmpty((Object)response)) {
            throw new RuntimeException("get token error");
        }
        Map result = (Map)Jsons.toBean((String)response, Map.class);
        Map rtn = (Map)result.get("returnObject");
        token = (String)rtn.get("access_token");
    }

    public String getToken() {
        return token;
    }

    public <T> T sendRequest(String url, Map<String, Object> param) {
        String json = Jsons.toJson(param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jsonStr", json);
        map.put("access_token", token);
        String response = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)response)) {
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code)) {
                EasRequestHelper.initToken();
                return this.sendRequest(url, param);
            }
            return (T)result.get("returnObject");
        }
        return null;
    }

    public String sendBody(String url, Map<String, String> map) {
        map.put("access_token", token);
        String body = Https.getInstance().post(url, map);
        if (Beans.isNotEmpty((Object)body)) {
            Map result = (Map)Jsons.toBean((String)body, Map.class);
            String code = result.get("errorCode").toString();
            if (TOKEN_EXPIRE.equals(code)) {
                EasRequestHelper.initToken();
                return this.sendBody(url, map);
            }
            return body;
        }
        return null;
    }
}

