/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.yorder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class GenEntityOracle {
    private String packageOutPath = "com.tcbj.crm.ygift";
    private String authorName = "yangzl";
    private String tablename = "RPT_GIFTLIST_V";
    private String[] colnames;
    private String[] colTypes;
    private int[] colSizes;
    private boolean f_util = false;
    private boolean f_sql = false;
    private static final String URL = "jdbc:oracle:thin:@192.168.100.216:1521:CRMDEV";
    private static final String NAME = "SIEBEL";
    private static final String PASS = "BYSIEBEL";
    private static final String DRIVER = "oracle.jdbc.driver.OracleDriver";

    public GenEntityOracle() {
        String sql = "select * from " + this.tablename;
        Statement pStemt = null;
        try {
            try {
                Class.forName(DRIVER);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            Connection con = DriverManager.getConnection(URL, NAME, PASS);
            pStemt = con.createStatement();
            ResultSet rs = pStemt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int size = rsmd.getColumnCount();
            this.colnames = new String[size];
            this.colTypes = new String[size];
            this.colSizes = new int[size];
            int i = 0;
            while (i < size) {
                this.colnames[i] = rsmd.getColumnName(i + 1);
                this.colTypes[i] = rsmd.getColumnTypeName(i + 1);
                if (this.colTypes[i].equalsIgnoreCase("date") || this.colTypes[i].equalsIgnoreCase("timestamp")) {
                    this.f_util = true;
                }
                if (this.colTypes[i].equalsIgnoreCase("blob") || this.colTypes[i].equalsIgnoreCase("char")) {
                    this.f_sql = true;
                }
                this.colSizes[i] = rsmd.getColumnDisplaySize(i + 1);
                ++i;
            }
            String content = this.parse(this.colnames, this.colTypes, this.colSizes);
            try {
                File directory = new File("");
                String path = this.getClass().getResource("").getPath();
                System.out.println(path);
                System.out.println("src/?/" + path.substring(path.lastIndexOf("/com/", path.length())));
                String[] tablenameArray = this.tablename.split("_");
                String outputPath = String.valueOf(directory.getAbsolutePath()) + "/src/" + this.packageOutPath.replace(".", "/") + "/" + this.initcap(tablenameArray[1]) + ".java";
                FileWriter fw = new FileWriter(outputPath);
                PrintWriter pw = new PrintWriter(fw);
                pw.println(content);
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String parse(String[] colnames, String[] colTypes, int[] colSizes) {
        StringBuffer sb = new StringBuffer();
        sb.append("package " + this.packageOutPath + ";\r\n");
        sb.append("\r\n");
        if (this.f_util) {
            sb.append("import java.util.Date;\r\n");
        }
        if (this.f_sql) {
            sb.append("import java.sql.*;\r\n");
        }
        sb.append("import java.io.Serializable;\r\n");
        sb.append("import javax.persistence.Column;\r\n");
        sb.append("import javax.persistence.Entity;\r\n");
        sb.append("import javax.persistence.Table;\r\n");
        sb.append("   /**\r\n");
        sb.append("    * " + this.tablename + " \u5b9e\u4f53\u7c7b\r\n");
        sb.append("    * " + new Date() + " " + this.authorName + "\r\n");
        sb.append("    */ \r\n");
        String[] tablenameArray = this.tablename.split("_");
        sb.append("@Entity\r\n");
        sb.append("@Table(name=\"" + this.tablename + "\")");
        sb.append("\r\n\r\npublic class " + this.initcap(tablenameArray[1]) + " extends IdEntity implements Serializable{\r\n");
        this.processAllAttrs(sb);
        this.processAllMethod(sb);
        sb.append("}\r\n");
        return sb.toString();
    }

    private void processAllAttrs(StringBuffer sb) {
        int i = 1;
        while (i < this.colnames.length) {
            sb.append("\tprivate " + this.sqlType2JavaType(this.colTypes[i]) + " " + this.colnames[i].toLowerCase() + ";\r\n");
            ++i;
        }
    }

    private void processAllMethod(StringBuffer sb) {
        int i = 1;
        while (i < this.colnames.length) {
            String colname = this.colnames[i].toLowerCase();
            sb.append("\tpublic void set" + this.initcap(colname) + "(" + this.sqlType2JavaType(this.colTypes[i]) + " " + colname + "){\r\n");
            sb.append("\tthis." + colname + "=" + colname + ";\r\n");
            sb.append("\t}\r\n");
            sb.append("\t@Column\r\n");
            sb.append("\tpublic " + this.sqlType2JavaType(this.colTypes[i]) + " get" + this.initcap(colname) + "(){\r\n");
            sb.append("\t\treturn " + colname + ";\r\n");
            sb.append("\t}\r\n");
            ++i;
        }
    }

    private String initcap(String str) {
        char[] ch = str.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    private String sqlType2JavaType(String sqlType) {
        if (sqlType.equalsIgnoreCase("binary_double")) {
            return "double";
        }
        if (sqlType.equalsIgnoreCase("binary_float")) {
            return "float";
        }
        if (sqlType.equalsIgnoreCase("blob")) {
            return "byte[]";
        }
        if (sqlType.equalsIgnoreCase("blob")) {
            return "byte[]";
        }
        if (sqlType.equalsIgnoreCase("char") || sqlType.equalsIgnoreCase("nvarchar2") || sqlType.equalsIgnoreCase("varchar2")) {
            return "String";
        }
        if (sqlType.equalsIgnoreCase("date") || sqlType.equalsIgnoreCase("timestamp") || sqlType.equalsIgnoreCase("timestamp with local time zone") || sqlType.equalsIgnoreCase("timestamp with time zone")) {
            return "Date";
        }
        if (sqlType.equalsIgnoreCase("number")) {
            return "Long";
        }
        return "String";
    }

    public static void main(String[] args) {
        new GenEntityOracle();
    }
}

