/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class ExcelUtils {
    public static void exportExcel(String fileName, String sheetName, String[] titles, List<?> data, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        while (i < titles.length) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(titles[i]);
            ++i;
        }
        i = 0;
        while (i < data.size()) {
            row = sheet.createRow(i + 1);
            Object obj = data.get(i);
            Field[] fields = obj.getClass().getDeclaredFields();
            int j = 0;
            while (j < fields.length) {
                HSSFCell cell = row.createCell(j);
                fields[j].setAccessible(true);
                Object result = fields[j].get(obj);
                cell.setCellValue(result == null ? "" : result.toString());
                ++j;
            }
            ++i;
        }
        fileName = URLDecoder.decode(fileName, "gbk");
        fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
        workbook.write((OutputStream)response.getOutputStream());
    }
}

