/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static float getDateSubtract(Date endDate, Date beginDate) {
        float subtractDate = 0.0f;
        BigDecimal subtract = new BigDecimal(endDate.getTime() - beginDate.getTime());
        subtractDate = subtract.divide(new BigDecimal(3600000L), 2, RoundingMode.HALF_UP).floatValue();
        return subtractDate;
    }

    public static String dateFormat(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static boolean equalsMonth(Date oneDate, Date twoDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        return format.format(oneDate).equals(format.format(twoDate));
    }

    public static int getDayOfMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return ((Calendar)calendar).getActualMaximum(5);
    }

    public static Date addSecond(Date date, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, second);
        return calendar.getTime();
    }

    public static Date addMinute(Date date, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static Date addHour(Date date, int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, hour);
        return calendar.getTime();
    }

    public static Date addDate(Date date, int dateNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, dateNum);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int monthNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, monthNum);
        return calendar.getTime();
    }

    public static Date parseDate(String dateStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFirstDay(String reportDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(reportDate, DATE_FORMAT));
        calendar.set(5, 1);
        return format.format(calendar.getTime());
    }

    public static String getLastDay(String reportDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(reportDate, DATE_FORMAT));
        calendar.set(5, calendar.getActualMaximum(5));
        return format.format(calendar.getTime());
    }

    public static Date getFirstDay(Date reportDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(reportDate);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastDay(Date reportDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(reportDate);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date getMiddleDayOfMonth(Date srcDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        calendar.setTime(DateUtil.parseDate(DateUtil.dateFormat(srcDate, "yyyy-MM-15"), DATE_FORMAT));
        return calendar.getTime();
    }

    public static Date getBeforeDay(Date srcDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        int day = calendar.get(5);
        calendar.set(5, day - 1);
        return calendar.getTime();
    }

    public static int getMaxDay(Date srcDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        return calendar.getMaximum(5);
    }
}

