/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.dto.inout;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tcbj.framework.errorcode.common.ResponseCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.context.i18n.LocaleContextHolder;

@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(value="BaseResponse", description="\u8fd4\u56de\u534f\u8bae")
public class BaseResponse<T>
implements Serializable {
    private static final long serialVersionUID = -4147625560055281066L;
    @ApiModelProperty(value="\u8bf7\u6c42\u5e8f\u5217", notes="\u5ba2\u6237\u7aef\u751f\u6210\u7684\u4e00\u4e2a\u5e8f\u5217\uff0c\u7528\u4e8e\u6807\u8bc6\u672c\u6b21\u8bf7\u6c42\uff0c\u901a\u5e38\u662f\u5ba2\u6237\u7aef\u7684\u65f6\u95f4\u5e8f\u5217", required=false, hidden=false)
    private String seq;
    @ApiModelProperty(value="\u4e3b\u8981\u4e1a\u52a1\u6570\u636e\u4f53", notes="\u4e3b\u8981\u4e1a\u52a1\u6570\u636e\u4f53", required=false, hidden=false)
    private T data;
    private int code = 0;
    private String msg = "^_^";

    public BaseResponse() {
        this.code = ResponseCode.SUCCESS;
    }

    public BaseResponse(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static <T> BaseResponse<T> success(T data) {
        BaseResponse<T> response = new BaseResponse<T>();
        response.setData(data);
        return response;
    }

    public static <T> BaseResponse<T> failure(int code, String msg) {
        return BaseResponse.failure(code, msg, null);
    }

    public static <T> BaseResponse<T> failure(int code, String msg, String[] msgPlaceholder) {
        Locale locale = LocaleContextHolder.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/messages", locale);
        msg = resourceBundle.getString(msg);
        if (msgPlaceholder != null) {
            MessageFormat messageFormat = new MessageFormat(msg);
            msg = messageFormat.format(msgPlaceholder);
        }
        return new BaseResponse<T>(code, msg);
    }

    public static <T> BaseResponse<T> success() {
        return new BaseResponse<T>();
    }

    public String getSeq() {
        return this.seq;
    }

    public T getData() {
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public BaseResponse<T> setSeq(String seq) {
        this.seq = seq;
        return this;
    }

    public BaseResponse<T> setData(T data) {
        this.data = data;
        return this;
    }

    public BaseResponse<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public BaseResponse<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$seq = this.getSeq();
        String other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !this$seq.equals(other$seq)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : $seq.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(seq=" + this.getSeq() + ", data=" + this.getData() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

