/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.marketing.auth.client.service;

import com.github.pagehelper.PageInfo;
import com.tcbj.framework.dto.inout.BasePageRequest;
import com.tcbj.framework.dto.inout.BaseRequest;
import com.tcbj.framework.dto.inout.BaseResponse;
import com.tcbj.marketing.auth.client.inout.request.AuthFunctionRequest;
import com.tcbj.marketing.auth.client.inout.request.ECCreateUserRequest;
import com.tcbj.marketing.auth.client.inout.request.QueryTenantRequest;
import com.tcbj.marketing.auth.client.inout.request.QueryTermsRequest;
import com.tcbj.marketing.auth.client.inout.request.QueryUserEmployeeRequest;
import com.tcbj.marketing.auth.client.inout.request.QueryUserRequest;
import com.tcbj.marketing.auth.client.inout.request.SaveTenantRequest;
import com.tcbj.marketing.auth.client.inout.request.SaveUserEmployeeRequest;
import com.tcbj.marketing.auth.client.inout.request.SaveUserRsPurviewRequest;
import com.tcbj.marketing.auth.client.inout.request.UserRsPurview;
import com.tcbj.marketing.auth.client.inout.response.AccountDto;
import com.tcbj.marketing.auth.client.inout.response.ECCreateUserInfoDto;
import com.tcbj.marketing.auth.client.inout.response.FunctionInfoDto;
import com.tcbj.marketing.auth.client.inout.response.MenuInfoDto;
import com.tcbj.marketing.auth.client.inout.response.SystemInfoDto;
import com.tcbj.marketing.auth.client.inout.response.TenantDto;
import com.tcbj.marketing.auth.client.inout.response.UserEmployeeDto;
import com.tcbj.marketing.auth.client.inout.response.UserInfoDto;
import com.tcbj.marketing.auth.client.inout.response.UserInfoEntityDto;
import com.tcbj.marketing.auth.client.service.TermsClientServiceHystrix;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(value="marketing-auth-server", path="/auth-server", fallback=TermsClientServiceHystrix.class, decode404=true)
public interface TermsClient {
    @PostMapping(value={"/terms/getUserInfo"})
    public BaseResponse<UserInfoDto> getUserInfo(BaseRequest<?> var1);

    @PostMapping(value={"/terms/getSystemInfo"})
    @ResponseBody
    public BaseResponse<List<SystemInfoDto>> getSystemInfo(BaseRequest<?> var1);

    @PostMapping(value={"/terms/getSystemMenuInfo"})
    @ResponseBody
    public BaseResponse<List<MenuInfoDto>> getSystemMenuInfo(BaseRequest<QueryTermsRequest> var1);

    @PostMapping(value={"/terms/getFunctionInfo"})
    @ResponseBody
    public BaseResponse<List<FunctionInfoDto>> getFunctionInfo(BaseRequest<QueryTermsRequest> var1);

    @PostMapping(value={"/terms/getFunctionInfoByUserId"})
    @ResponseBody
    public BaseResponse<List<FunctionInfoDto>> getFunctionInfoByUserId(BaseRequest<QueryTermsRequest> var1);

    @PostMapping(value={"/terms/getTotalFunctionInfo"})
    @ResponseBody
    public BaseResponse<List<FunctionInfoDto>> getTotalFunctionInfo(BaseRequest<QueryTermsRequest> var1);

    @PostMapping(value={"/terms/authFunction"})
    @ResponseBody
    public BaseResponse<Boolean> authFunction(BaseRequest<AuthFunctionRequest> var1);

    @RequestMapping(value={"/usermgr/list"}, method={RequestMethod.POST})
    public BaseResponse<PageInfo<UserInfoEntityDto>> page(BasePageRequest<QueryUserRequest> var1);

    @RequestMapping(value={"/usermgr/getUserEmployee"}, method={RequestMethod.POST})
    public BaseResponse<List<UserEmployeeDto>> getUserEmployee(BaseRequest<QueryUserEmployeeRequest> var1);

    @RequestMapping(value={"/usermgr/saveUserEmployee"}, method={RequestMethod.POST})
    public BaseResponse<?> saveUserEmployee(BaseRequest<SaveUserEmployeeRequest> var1);

    @RequestMapping(value={"/usermgr/getAccountInfo"}, method={RequestMethod.POST})
    public BaseResponse<AccountDto> getAccountInfo(BaseRequest<QueryUserEmployeeRequest> var1);

    @PostMapping(value={"/terms/saveUserFunctionPurview"})
    @ResponseBody
    public BaseResponse<?> saveUserFunctionPurview(BaseRequest<SaveUserRsPurviewRequest> var1);

    @RequestMapping(value={"/usermgr/createEcUser"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<ECCreateUserInfoDto> ecCreateUser(@RequestBody BaseRequest<ECCreateUserRequest> var1);

    @RequestMapping(value={"/terms/parseToken"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<UserInfoDto> parseToken(@RequestBody BaseRequest<?> var1);

    @RequestMapping(value={"/tenant/queryUserTenantMap"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<Map<String, String>> queryUserTenantMap(@RequestBody BaseRequest<UserRsPurview> var1);

    @RequestMapping(value={"/tenant/getTenant"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<TenantDto> getTenant(@RequestBody BaseRequest<SaveTenantRequest> var1);

    @RequestMapping(value={"/tenant/getTenantByCityCodes"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<List<String>> getTenantByCityCodes(@RequestBody BaseRequest<QueryTenantRequest> var1);

    @RequestMapping(value={"/usermgr/getUsersByTenantIds"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<Set<String>> getUsersByTenantIds(@RequestBody BasePageRequest<QueryUserRequest> var1);

    @PostMapping(value={"/terms/getTenantMenuInfo"})
    @ResponseBody
    public BaseResponse<List<HashMap<String, List<MenuInfoDto>>>> getTenantMenuInfo(BaseRequest<QueryTermsRequest> var1);
}

