/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.marketing.openapi.backlog.server.common;

import com.tcbj.framework.dto.inout.BaseRequest;
import com.tcbj.framework.dto.inout.BaseResponse;
import com.tcbj.jdbc.annotation.Column;
import com.tcbj.jdbc.annotation.Id;
import com.tcbj.jdbc.annotation.Table;
import com.tcbj.marketing.auth.client.service.YXYClient;
import com.tcbj.marketing.auth.client.service.YYClient;
import com.tcbj.msyxy.common.dto.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.UUIDUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class ClientBaseDao {
    private YXYClient yxyClient;
    private YYClient yyClient;

    public ClientBaseDao(YXYClient yxyClient) {
        this.yxyClient = yxyClient;
    }

    public ClientBaseDao(YYClient yyClient) {
        this.yyClient = yyClient;
    }

    public <T> List<T> selectList(String sql, List<Object> args, Class<T> clazz) {
        BaseRequest baseRequest = new BaseRequest();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sql", sql);
        if (args != null && args.size() > 0) {
            hashMap.put("args", args);
        }
        baseRequest.setRequest(hashMap);
        BaseResponse response = new BaseResponse();
        response = this.yyClient != null ? this.yyClient.selectList(baseRequest) : this.yxyClient.selectList(baseRequest);
        if (clazz.getName().equals(Map.class.getName()) || clazz.getName().equals(HashMap.class.getName())) {
            return (List)response.getData();
        }
        List list = (List)response.getData();
        List list2 = this.toBeanList(list, clazz);
        return list2;
    }

    public <T> List<T> selectMiddleDataList(String sql, List<Object> args, Class<T> clazz) {
        BaseRequest baseRequest = new BaseRequest();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sql", sql);
        if (args != null && args.size() > 0) {
            hashMap.put("args", args);
        }
        baseRequest.setRequest(hashMap);
        BaseResponse response = new BaseResponse();
        response = this.yxyClient.selectMiddleDataList(baseRequest);
        if (clazz.getName().equals(Map.class.getName()) || clazz.getName().equals(HashMap.class.getName())) {
            return (List)response.getData();
        }
        List list = (List)response.getData();
        List list2 = this.toBeanList(list, clazz);
        return list2;
    }

    public <T> Page findByPage(String sql, List<Object> args, int page, int showPage, Class<T> clazz) {
        BaseRequest baseRequest = new BaseRequest();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sql", sql);
        hashMap.put("page", page);
        hashMap.put("pageShow", showPage);
        if (args != null && args.size() > 0) {
            hashMap.put("args", args);
        }
        baseRequest.setRequest(hashMap);
        BaseResponse findByPage = new BaseResponse();
        findByPage = this.yyClient != null ? this.yyClient.findByPage(baseRequest) : this.yxyClient.findByPage(baseRequest);
        HashMap bean = (HashMap)Jsons.toBean((String)findByPage.getSeq(), Map.class);
        if (clazz.getName().equals(Map.class.getName()) || clazz.getName().equals(HashMap.class.getName())) {
            Page page2 = new Page(page, ((List)findByPage.getData()).size(), ((Integer)bean.get("count")).intValue(), (List)findByPage.getData());
            return page2;
        }
        List data = (List)findByPage.getData();
        List list2 = this.toBeanList(data, clazz);
        Page page2 = new Page(page, list2.size(), ((Integer)bean.get("count")).intValue(), list2);
        return page2;
    }

    public void execute(String sql, List<Object> args) {
        BaseRequest baseRequest = new BaseRequest();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sql", sql);
        if (args != null && args.size() > 0) {
            hashMap.put("args", args);
        }
        baseRequest.setRequest(hashMap);
        if (this.yyClient != null) {
            this.yyClient.execute(baseRequest);
        } else {
            this.yxyClient.execute(baseRequest);
        }
    }

    public void execute(String sql) {
        this.execute(sql, null);
    }

    public void updateEntity(Object obj) {
        Field[] fields;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String key_name = null;
        Object key_val = null;
        Table annotation = obj.getClass().getAnnotation(Table.class);
        String name = annotation.name();
        sql.append("update " + name + " set ");
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            Id id = field.getAnnotation(Id.class);
            if (id != null && key_name == null) {
                key_name = column.name();
                key_val = this.getFieldValueByName(field.getName(), obj);
                continue;
            }
            Object object = this.getFieldValueByName(field.getName(), obj);
            if (object == null) continue;
            try {
                Class type = PropertyUtils.getPropertyType((Object)obj, (String)field.getName());
                if ("class java.util.Date".equals(type.toString())) {
                    sql.append(column.name() + "=to_date(?,'yyyy-MM-dd HH24:mi:ss'),");
                    Date date = (Date)object;
                    String formartDate = DateUtils.formartDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                    args.add(formartDate);
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sql.append(column.name() + "=?,");
            args.add(object);
        }
        if (key_name == null) {
            return;
        }
        String sqls = sql.toString().substring(0, sql.toString().length() - 1) + " where " + key_name + "=?";
        args.add(key_val);
        this.execute(sqls, args);
    }

    public void batchUpdateEntity(List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            this.updateEntity(object);
        }
    }

    private Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> List<T> toBeanList(List<Map<String, Object>> list, Class<T> clazz) {
        ArrayList ls = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Map<String, Object> map = list.get(i);
                Object object = Class.forName(clazz.getName()).newInstance();
                this.toBean(map, object);
                ls.add(object);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ls;
    }

    private Object toBean(Map<String, Object> map, Object obj) {
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            if (map.get(name) == null) continue;
            String value = map.get(name).toString();
            try {
                Field[] fields;
                for (Field field : fields = obj.getClass().getDeclaredFields()) {
                    String name_db;
                    Column column = field.getAnnotation(Column.class);
                    if (column == null || !name.equals(name_db = column.name())) continue;
                    name = field.getName();
                }
                Class type = PropertyUtils.getPropertyType((Object)obj, (String)name);
                if (type == null) continue;
                if ("class java.util.Date".equals(type.toString())) {
                    PropertyUtils.setProperty((Object)obj, (String)name, (Object)ConvertUtils.convert((Object)new Date(Long.parseLong(value)), (Class)type));
                    continue;
                }
                PropertyUtils.setProperty((Object)obj, (String)name, (Object)ConvertUtils.convert((String)value, (Class)type));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return obj;
    }

    private <T> T toBean(Map<String, Object> map, Object obj, Class<T> clazz) {
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            if (map.get(name) == null) continue;
            String value = map.get(name).toString();
            try {
                Field[] fields;
                for (Field field : fields = obj.getClass().getDeclaredFields()) {
                    String name_db;
                    Column column = field.getAnnotation(Column.class);
                    if (column == null || !name.equals(name_db = column.name())) continue;
                    name = field.getName();
                }
                Class type = PropertyUtils.getPropertyType((Object)obj, (String)name);
                if (type == null) continue;
                if ("class java.util.Date".equals(type.toString())) {
                    PropertyUtils.setProperty((Object)obj, (String)name, (Object)ConvertUtils.convert((Object)new Date(Long.parseLong(value)), (Class)type));
                    continue;
                }
                PropertyUtils.setProperty((Object)obj, (String)name, (Object)ConvertUtils.convert((String)value, (Class)type));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (T)obj;
    }

    public <T> T selectOne(String sql, List<String> args, Class<T> clazz) {
        BaseRequest baseRequest = new BaseRequest();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sql", sql);
        if (args != null && args.size() > 0) {
            hashMap.put("args", args);
        }
        baseRequest.setRequest(hashMap);
        BaseResponse response = new BaseResponse();
        response = this.yyClient != null ? this.yyClient.selectList(baseRequest) : this.yxyClient.selectList(baseRequest);
        if (clazz.getName().equals(Map.class.getName()) || clazz.getName().equals(HashMap.class.getName())) {
            if (response.getData() == null || ((List)response.getData()).size() == 0) {
                return null;
            }
            Map map = (Map)((List)response.getData()).get(0);
            return (T)map;
        }
        List list = (List)response.getData();
        if (list.size() == 0) {
            return null;
        }
        try {
            Map map = (Map)list.get(0);
            Object object = Class.forName(clazz.getName()).newInstance();
            this.toBean(map, object);
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void batchSaveEntity(List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            this.saveEntity(object);
        }
    }

    public void saveEntity(Object obj) {
        Field[] fields;
        StringBuffer sql = new StringBuffer();
        StringBuffer values = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String key_name = null;
        Object key_val = null;
        Table annotation = obj.getClass().getAnnotation(Table.class);
        String name = annotation.name();
        sql.append("insert into " + name + "(");
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            Id id = field.getAnnotation(Id.class);
            if (id != null && key_name == null) {
                key_name = column.name();
                key_val = this.getFieldValueByName(field.getName(), obj);
                if (key_val == null) {
                    key_val = UUIDUtils.getId();
                }
                sql.append(column.name() + ",");
                values.append("?,");
                args.add(key_val);
                continue;
            }
            Object object = this.getFieldValueByName(field.getName(), obj);
            if (object == null) continue;
            try {
                Class type = PropertyUtils.getPropertyType((Object)obj, (String)field.getName());
                if ("class java.util.Date".equals(type.toString())) {
                    sql.append(column.name() + ",");
                    values.append("to_date(?,'yyyy-MM-dd HH24:mi:ss'),");
                    Date date = (Date)object;
                    String formartDate = DateUtils.formartDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                    args.add(formartDate);
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sql.append(column.name() + ",");
            values.append("?,");
            args.add(object);
        }
        if (key_name == null) {
            return;
        }
        String sqls = sql.toString().substring(0, sql.toString().length() - 1) + ") values(" + values.toString().substring(0, values.toString().length() - 1) + ")";
        this.execute(sqls, args);
    }

    public <T> T selectById(String id, Class<T> clazz) {
        Field[] fields;
        ArrayList<String> args = new ArrayList<String>();
        args.add(id);
        Table annotation = clazz.getAnnotation(Table.class);
        String name = annotation.name();
        String key_name = "row_id";
        for (Field field : fields = clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            Id key = field.getAnnotation(Id.class);
            if (key == null) continue;
            key_name = column.name();
            break;
        }
        Object one = this.selectOne("select * from " + name + " where " + key_name + "=?", args, clazz);
        return (T)one;
    }
}

