/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.marketing.openapi.backlog.server.controller;

import com.tcbj.framework.dto.inout.BaseRequest;
import com.tcbj.framework.dto.inout.BaseResponse;
import com.tcbj.marketing.openapi.backlog.client.inout.request.QueryDeskRequest;
import com.tcbj.marketing.openapi.backlog.client.inout.response.DeskDataDto;
import com.tcbj.marketing.openapi.backlog.server.service.DeskYxyService;
import com.tcbj.marketing.openapi.backlog.server.service.DeskYyService;
import com.tcbj.util.Beans;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/desk"})
public class DeskController {
    @Autowired
    private Environment env;
    @Autowired
    private DeskYyService deskYyService;
    @Autowired
    private DeskYxyService deskYxyService;

    @RequestMapping(value={"/getToDoList"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse<DeskDataDto> getToDoList(@RequestBody BaseRequest<QueryDeskRequest> request, HttpServletRequest httpReq) {
        String link;
        HashMap<String, Date> CacheDate;
        String orgId = request.getRequest() == null ? "" : ((QueryDeskRequest)request.getRequest()).getOrgId();
        String userId = request.getRequest() == null ? "" : ((QueryDeskRequest)request.getRequest()).getUserId();
        orgId = orgId == null ? "" : orgId.toString();
        userId = userId == null ? "" : userId.toString();
        ServletContext application = httpReq.getSession().getServletContext();
        HashMap<String, BaseResponse> CacheData = application.getAttribute("CacheData");
        if (CacheData == null) {
            CacheData = new HashMap<String, BaseResponse>();
        }
        if ((CacheDate = application.getAttribute("CacheDate")) == null) {
            CacheDate = new HashMap<String, Date>();
        }
        String key = orgId + "#" + userId;
        try {
            HashMap<String, BaseResponse> CacheDataNew = CacheData;
            HashMap<String, Date> CacheDateNew = CacheDate;
            if (Beans.isNotEmpty(CacheDataNew.get(key)) && Beans.isNotEmpty(CacheDateNew.get(key))) {
                Date date = (Date)CacheDateNew.get(key);
                long times = new Date().getTime() - date.getTime();
                if (times < 180000L) {
                    return (BaseResponse)CacheDataNew.get(key);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList list = new ArrayList();
        HashMap map = this.getOrgIdConfig();
        if ("yycsp".equals(map.get(orgId))) {
            link = this.env.getProperty("yycsp_link");
            this.deskYyService.getToDoList_yycsp(list, request, link);
        } else if ("bjcsp".equals(map.get(orgId))) {
            link = this.env.getProperty("bjcsp_link");
            this.deskYxyService.getToDoList_bjcsp(list, request, link);
        } else if ("yxycsp".equals(map.get(orgId))) {
            link = this.env.getProperty("yxycsp_link");
            this.deskYxyService.getToDoList_yxycsp(list, request, link);
        } else {
            link = this.env.getProperty("yxycsp_link");
            this.deskYxyService.getToDoList_yxycsp(list, request, link);
        }
        DeskDataDto deskDataDto = new DeskDataDto();
        deskDataDto.setData(list);
        BaseResponse response = new BaseResponse();
        response.setData((Object)deskDataDto);
        try {
            HashMap<String, BaseResponse> CacheDataNew = CacheData;
            HashMap<String, Date> CacheDateNew = CacheDate;
            CacheDataNew.put(key, response);
            CacheDateNew.put(key, new Date());
            application.setAttribute("CacheData", CacheDataNew);
            application.setAttribute("CacheDate", CacheDateNew);
        }
        catch (Exception e) {
            // empty catch block
        }
        return response;
    }

    public HashMap<String, String> getOrgIdConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.env.getProperty("yycsp"), "yycsp");
        map.put(this.env.getProperty("bjcsp"), "bjcsp");
        map.put(this.env.getProperty("yxycsp"), "yxycsp");
        return map;
    }
}

