/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.conf;

import com.tcbj.jdbc.core.BaseOperation;
import com.tcbj.jdbc.io.JdbcConfiguration;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={BaseOperation.class})
public class JdbcAutoConfig {
    @Autowired
    private DataSource datasource;
    @Autowired
    private Environment env;

    @Bean
    public BaseOperation baseOperation() throws Exception {
        JdbcConfiguration conf = new JdbcConfiguration();
        conf.setDatasource(this.datasource);
        conf.setDialect(this.env.getProperty("tcbj.jdbc.dialect"));
        conf.setKeygen(this.env.getProperty("tcbj.jdbc.keygen"));
        conf.setPackagesToScan(this.env.getProperty("tcbj.jdbc.packagesToScan"));
        BaseOperation oper = new BaseOperation(conf);
        return oper;
    }
}

