/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.core;

import com.tcbj.jdbc.core.SelectOperation;
import com.tcbj.jdbc.core.TcbjJdbcTemplate;
import com.tcbj.jdbc.core.UpdateOperation;
import com.tcbj.jdbc.core.builder.DeleteSqlBuilder;
import com.tcbj.jdbc.core.builder.InsertSqlBuilder;
import com.tcbj.jdbc.core.builder.UpdateSqlBuilder;
import com.tcbj.jdbc.core.rowmapper.EntityRowMapper;
import com.tcbj.jdbc.core.statement.BeanMapStatement;
import com.tcbj.jdbc.core.statement.ResultSet;
import com.tcbj.jdbc.io.JdbcConfiguration;
import com.tcbj.jdbc.io.TableMetaInfo;
import com.tcbj.jdbc.util.Page;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class BaseOperation
implements UpdateOperation,
SelectOperation {
    private TcbjJdbcTemplate jdbcTemplate;

    public BaseOperation(JdbcConfiguration config) throws Exception {
        this.jdbcTemplate = new TcbjJdbcTemplate(config);
    }

    @Override
    public <T, V> V saveEntity(T entity) {
        BeanMapStatement st = new BeanMapStatement(entity.getClass(), this.jdbcTemplate);
        st.setSqlBuilder(new InsertSqlBuilder(this.jdbcTemplate.getKeyGenerator()));
        st.setObject(entity);
        st.updateNull();
        ResultSet rs = st.executeUpdate();
        return (V)rs.getKeyHolder().getKeys().get(0);
    }

    @Override
    public <T> int updateEntity(T entity) {
        BeanMapStatement st = new BeanMapStatement(entity.getClass(), this.jdbcTemplate);
        st.setSqlBuilder(new UpdateSqlBuilder());
        st.setObject(entity);
        st.updateNull();
        ResultSet rs = st.executeUpdate();
        return rs.getEffectRows();
    }

    @Override
    public <T> int deleteEntity(T entity) {
        BeanMapStatement st = new BeanMapStatement(entity.getClass(), this.jdbcTemplate);
        st.setSqlBuilder(new DeleteSqlBuilder());
        st.setObject(entity);
        ResultSet rs = st.executeUpdate();
        return rs.getEffectRows();
    }

    @Override
    public <T> int batchSaveEntity(List<T> list) {
        if (list != null && !list.isEmpty()) {
            BeanMapStatement st = new BeanMapStatement(list.get(0).getClass(), this.jdbcTemplate);
            st.setSqlBuilder(new InsertSqlBuilder(this.jdbcTemplate.getKeyGenerator()));
            st.addBatch(list);
            st.updateNull();
            ResultSet rs = st.executeBatch();
            return rs.getEffectRows();
        }
        return 0;
    }

    @Override
    public <T> int batchUpdateEntity(List<T> list) {
        if (list != null && !list.isEmpty()) {
            BeanMapStatement st = new BeanMapStatement(list.get(0).getClass(), this.jdbcTemplate);
            st.setSqlBuilder(new UpdateSqlBuilder());
            st.addBatch(list);
            st.updateNull();
            ResultSet rs = st.executeBatch();
            return rs.getEffectRows();
        }
        return 0;
    }

    @Override
    public <T> int updateEntityNotNull(T entity) {
        BeanMapStatement st = new BeanMapStatement(entity.getClass(), this.jdbcTemplate);
        st.setSqlBuilder(new UpdateSqlBuilder());
        st.setObject(entity);
        ResultSet rs = st.executeUpdate();
        return rs.getEffectRows();
    }

    @Override
    public <T> int batchUpdateEntityNotNull(List<T> list) {
        if (list != null && !list.isEmpty()) {
            BeanMapStatement st = new BeanMapStatement(list.get(0).getClass(), this.jdbcTemplate);
            st.setSqlBuilder(new UpdateSqlBuilder());
            st.addBatch(list);
            ResultSet rs = st.executeBatch();
            return rs.getEffectRows();
        }
        return 0;
    }

    @Override
    public <T> Page<T> findByPage(String sql, List<Object> args, int pageNo, int pageSize, Class<T> clazz) {
        String countSql = " select count(1) from (" + sql + ")  tab_";
        Object[] param = args == null ? null : args.toArray();
        int totalRecord = (Integer)this.jdbcTemplate.queryForObject(countSql, param, Integer.class);
        String pageSql = this.jdbcTemplate.getDialect().getPageSql(sql, pageNo, pageSize);
        List result = this.jdbcTemplate.query(pageSql, param, this.getRowMapper(clazz));
        return new Page(pageNo, pageSize, totalRecord, result);
    }

    @Override
    public <T> List<T> selectList(String sql, List<Object> args, Class<T> clazz) {
        List l = this.jdbcTemplate.query(sql, args.toArray(), this.getRowMapper(clazz));
        return l;
    }

    @Override
    public <T> T selectOne(String sqlKey, List<Object> args, Class<T> clazz) {
        List<T> list = this.selectList(sqlKey, args, clazz);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private RowMapper<?> getRowMapper(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return new ColumnMapRowMapper();
        }
        TableMetaInfo tableInfo = this.jdbcTemplate.getTableInfo(clazz);
        return new EntityRowMapper(tableInfo);
    }

    @Override
    public void execute(String sql, List<Object> args) {
        this.jdbcTemplate.execute(sql);
    }
}

