/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.core;

import com.tcbj.jdbc.core.keygen.KeyGenerator;
import com.tcbj.jdbc.dialect.DialectHandler;
import com.tcbj.jdbc.exception.PersistentException;
import com.tcbj.jdbc.io.ColumnMetaInfo;
import com.tcbj.jdbc.io.JdbcConfiguration;
import com.tcbj.jdbc.io.TableMetaInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ClassUtils;

public class TcbjJdbcTemplate
extends JdbcTemplate {
    private static final String DEFAULT_RESOURCE_PATTERN = "/**/*.class";
    private DialectHandler dialectHandler;
    private KeyGenerator keygen;
    private Map<Class<?>, TableMetaInfo> tableMappings = new HashMap();

    public TcbjJdbcTemplate(JdbcConfiguration config) throws Exception {
        super(config.getDatasource());
        this.dialectHandler = (DialectHandler)Class.forName(config.getDialect()).newInstance();
        this.keygen = (KeyGenerator)Class.forName(config.getKeygen()).newInstance();
        this.initTableMappings(config.getPackagesToScan());
    }

    private void initTableMappings(String packagesToScan) {
        String[] packages = packagesToScan.split(",");
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        try {
            for (String path : packages) {
                String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)path) + DEFAULT_RESOURCE_PATTERN;
                Resource[] ress = resourceResolver.getResources(packageSearchPath);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourceResolver);
                for (Resource resource : ress) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    this.addClass(resourceResolver.getClassLoader().loadClass(className));
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistentException("faild to load  entity resource from package " + packagesToScan);
        }
    }

    private void addClass(Class<?> clazz) {
        Table t = clazz.getAnnotation(Table.class);
        if (t != null) {
            TableMetaInfo table = new TableMetaInfo();
            table.setTabName(t.name());
            table.setClazz(clazz);
            Field[] tempF = clazz.getDeclaredFields();
            boolean hasId = false;
            for (Field f : tempF) {
                ColumnMetaInfo col = new ColumnMetaInfo();
                Column c = f.getAnnotation(Column.class);
                if (c == null) continue;
                col.setColumnName(c.name());
                col.setFieldName(f.getName());
                col.setFieldType(f.getType());
                Id id = f.getAnnotation(Id.class);
                if (id != null) {
                    hasId = true;
                    col.setPrimaryKey(true);
                    if (table.getPrimaryColumn() != null) {
                        throw new PersistentException("multiple annotation @Id in class " + clazz.getName() + "");
                    }
                    table.setPrimaryColumn(col);
                }
                table.getColumns().add(col);
            }
            if (!hasId) {
                throw new PersistentException("class " + clazz.getName() + " should add an id");
            }
            this.tableMappings.put(clazz, table);
        }
    }

    public DialectHandler getDialect() {
        return this.dialectHandler;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keygen;
    }

    public TableMetaInfo getTableInfo(Class<?> clazz) {
        TableMetaInfo tab = this.tableMappings.get(clazz);
        if (tab == null) {
            throw new PersistentException("can not find mapped class " + clazz.getName());
        }
        return tab;
    }
}

