/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.core.builder;

import com.tcbj.jdbc.core.builder.SqlBuilder;
import com.tcbj.jdbc.core.keygen.KeyGenerator;
import com.tcbj.jdbc.dialect.DialectHandler;
import com.tcbj.jdbc.io.SqlContext;
import com.tcbj.jdbc.io.TableMetaInfo;
import com.tcbj.jdbc.util.BeanMapUtil;
import java.util.ArrayList;
import java.util.Map;

public class InsertSqlBuilder
implements SqlBuilder {
    private KeyGenerator keygen;

    public InsertSqlBuilder(KeyGenerator keygen) {
        this.keygen = keygen;
    }

    @Override
    public SqlContext build(TableMetaInfo tableInfo, Object target, DialectHandler dialect, boolean buildNull) {
        StringBuilder sb = new StringBuilder();
        StringBuilder args = new StringBuilder();
        sb.append(" insert into ").append(tableInfo.getTabName()).append(" (");
        Map<String, Object> map = BeanMapUtil.toMap(target);
        ArrayList<Object> param = new ArrayList<Object>();
        Object id = this.keygen.generateId();
        tableInfo.getColumns().forEach(col -> {
            String colProperty = col.getFieldName();
            if (col.isPrimaryKey()) {
                sb.append(col.getColumnName()).append(",");
                args.append(" ?,");
                param.add(id);
            } else if (map.get(colProperty) != null) {
                sb.append(col.getColumnName()).append(",");
                args.append(" ?,");
                param.add(map.get(colProperty));
            }
        });
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") values (");
        args.deleteCharAt(args.length() - 1);
        sb.append(args.toString()).append(")");
        SqlContext context = new SqlContext(sb.toString());
        context.setParam(param);
        context.setGenerateId(id);
        return context;
    }
}

