/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.core.builder;

import com.tcbj.jdbc.core.builder.SqlBuilder;
import com.tcbj.jdbc.dialect.DialectHandler;
import com.tcbj.jdbc.io.ColumnMetaInfo;
import com.tcbj.jdbc.io.SqlContext;
import com.tcbj.jdbc.io.TableMetaInfo;
import com.tcbj.jdbc.util.BeanMapUtil;
import java.util.ArrayList;
import java.util.Map;

public class UpdateSqlBuilder
implements SqlBuilder {
    @Override
    public SqlContext build(TableMetaInfo tableInfo, Object target, DialectHandler dialect, boolean buildNull) {
        StringBuilder sb = new StringBuilder();
        sb.append(" update ").append(tableInfo.getTabName()).append(" set ");
        Map<String, Object> map = BeanMapUtil.toMap(target);
        ArrayList<Object> param = new ArrayList<Object>();
        tableInfo.getColumns().forEach(col -> {
            if (!col.isPrimaryKey()) {
                String colProperty = col.getFieldName();
                if (buildNull || map.get(colProperty) != null) {
                    sb.append(col.getColumnName()).append("= ? ,");
                    param.add(map.get(colProperty));
                }
            }
        });
        sb.deleteCharAt(sb.length() - 1);
        ColumnMetaInfo primaryKeyCol = tableInfo.getPrimaryColumn();
        sb.append(" where ").append(primaryKeyCol.getColumnName()).append(" = ? ");
        param.add(map.get(primaryKeyCol.getFieldName()));
        SqlContext context = new SqlContext(sb.toString());
        context.setParam(param);
        return context;
    }
}

