/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.core.rowmapper;

import com.tcbj.jdbc.io.TableMetaInfo;
import com.tcbj.jdbc.util.BeanMapUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;

public class EntityRowMapper
implements RowMapper<Object> {
    private TableMetaInfo tableInfo;

    public EntityRowMapper(TableMetaInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public Object mapRow(ResultSet resultset, int i) throws SQLException {
        Object entity = this.getObject();
        Map<String, Object> map = BeanMapUtil.toMap(entity);
        this.tableInfo.getColumns().forEach(col -> {
            if (this.isExistColumn(resultset, col.getColumnName())) {
                try {
                    map.put(col.getFieldName(), EntityRowMapper.getValue(col.getFieldType(), resultset.getObject(col.getColumnName())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return entity;
    }

    private Object getObject() {
        try {
            Object entity = this.tableInfo.getClazz().newInstance();
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException("can not instance class :" + this.tableInfo.getClass().getName());
        }
    }

    public boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private static Object getValue(Class clazz, Object value) {
        if (value == null) {
            return value;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return value.toString();
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return new BigDecimal(value.toString());
        }
        if (Integer.TYPE == clazz || Integer.class.isAssignableFrom(clazz)) {
            return Integer.valueOf(value.toString());
        }
        if (Long.TYPE == clazz || Long.class.isAssignableFrom(clazz)) {
            return Long.valueOf(value.toString());
        }
        if (Double.TYPE == clazz || Double.class.isAssignableFrom(clazz)) {
            return Double.valueOf(value.toString());
        }
        if (Float.TYPE == clazz || Float.class.isAssignableFrom(clazz)) {
            return Float.valueOf(value.toString());
        }
        if (Byte.TYPE == clazz || Byte.class.isAssignableFrom(clazz)) {
            return Byte.valueOf(value.toString());
        }
        if (Short.TYPE == clazz || Short.class.isAssignableFrom(clazz)) {
            return Short.valueOf(value.toString());
        }
        return value;
    }
}

