/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.jdbc.core.statement;

import com.tcbj.jdbc.core.TcbjJdbcTemplate;
import com.tcbj.jdbc.core.keygen.KeyHolder;
import com.tcbj.jdbc.core.statement.AbstractStatement;
import com.tcbj.jdbc.core.statement.ResultSet;
import com.tcbj.jdbc.core.statement.Statement;
import com.tcbj.jdbc.exception.PersistentException;
import com.tcbj.jdbc.io.SqlContext;
import com.tcbj.jdbc.io.TableMetaInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;

public class BeanMapStatement
extends AbstractStatement
implements Statement {
    private Object param = null;
    private boolean updateNull = false;
    private List<Object> batchParam = new ArrayList<Object>();
    private TableMetaInfo tableInfo;

    public BeanMapStatement(Class<?> entityClass, TcbjJdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
        if (jdbcTemplate.getTableInfo(entityClass) == null) {
            throw new PersistentException(" no mapping for class " + entityClass.getName());
        }
        this.tableInfo = jdbcTemplate.getTableInfo(entityClass);
    }

    @Override
    public void addBatch(List<? extends Object> objs) {
        if (objs != null && objs.size() > 0) {
            this.batchParam.addAll(objs);
        }
    }

    @Override
    public ResultSet executeQuery() {
        throw new PersistentException("unsupport operation: query in map statement");
    }

    @Override
    public ResultSet executeUpdate() {
        this.checkSqlBuilder();
        SqlContext sqlContext = this.getSqlBuilder().build(this.tableInfo, this.param, this.jdbcTemplate.getDialect(), this.updateNull);
        int effectRows = this.jdbcTemplate.update(sqlContext.getSql(), sqlContext.getParam().toArray());
        KeyHolder kh = new KeyHolder();
        kh.getKeys().add(sqlContext.getGenerateId());
        kh.setColumnName(this.tableInfo.getPrimaryColumn().getColumnName());
        ResultSet rs = new ResultSet(effectRows, kh, null);
        return rs;
    }

    @Override
    public void setObject(Object obj) {
        this.param = obj;
    }

    public void updateNull() {
        this.updateNull = true;
    }

    @Override
    public ResultSet executeBatch() {
        this.checkSqlBuilder();
        HashMap<String, List> keyParam = new HashMap<String, List>();
        KeyHolder kh = new KeyHolder();
        kh.setColumnName(this.tableInfo.getPrimaryColumn().getColumnName());
        this.batchParam.forEach(m -> {
            SqlContext sqlContext = this.getSqlBuilder().build(this.tableInfo, m, this.jdbcTemplate.getDialect(), this.updateNull);
            kh.getKeys().add(sqlContext.getGenerateId());
            String key = sqlContext.getMd5Sql();
            if (keyParam.containsKey(key)) {
                ((List)keyParam.get(key)).add(sqlContext);
            } else {
                keyParam.put(key, new ArrayList());
                ((List)keyParam.get(key)).add(sqlContext);
            }
        });
        ResultSet rs = new ResultSet(0, kh, null);
        keyParam.forEach((m, list) -> {
            int[] ef;
            String sql = ((SqlContext)list.get(0)).getSql();
            ArrayList params = new ArrayList(list.size());
            IntStream.range(0, list.size()).forEach(index -> {
                Object[] args = ((SqlContext)list.get(index)).getParam().toArray();
                params.add(args);
            });
            for (int i : ef = this.jdbcTemplate.batchUpdate(sql, params)) {
                rs.setEffectRows(rs.getEffectRows() + i);
            }
        });
        return rs;
    }
}

