/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.bpm;

import com.tcbj.framework.bpm.Action;
import com.tcbj.framework.bpm.BpmContext;
import com.tcbj.framework.bpm.BpmDefine;
import com.tcbj.framework.bpm.BpmNode;
import com.tcbj.framework.bpm.BpmTransition;
import com.tcbj.framework.bpm.Event;
import com.tcbj.framework.exception.exception.Thrower;
import java.util.Map;
import org.springframework.util.StringUtils;

public class BpmProcessor<T> {
    private BpmContext<T> bpmContext = BpmContext.NEW();
    private BpmDefine<T> bpmDefine;

    public BpmProcessor(BpmDefine<T> bpmDefine, String operator, T businessObject, Map<String, Object> extParam) {
        this.bpmContext.operator(operator).businessObject(businessObject).extParam(extParam);
        this.bpmDefine = bpmDefine;
        BpmNode<T> currentNode = bpmDefine.getCurrentNode(this.bpmContext.getBusinessObject());
        this.bpmContext.currentNode(currentNode);
    }

    public BpmNode<T> process(String eventCode) {
        BpmTransition<T> fireTransition;
        Event currentEvent = this.bpmDefine.getEventByCode(eventCode);
        this.bpmContext.currentEvent(currentEvent);
        this.checkBpmParam();
        Action<T> action = this.bpmContext.getCurrentNode().getAction(currentEvent, this.bpmContext);
        if (action != null) {
            action.doAction(this.bpmContext);
        }
        if ((fireTransition = this.bpmContext.getCurrentNode().getTrasition(currentEvent)) != null) {
            return fireTransition.getNextNode(this.bpmContext);
        }
        Thrower.throwAppException((String)"0010", (String)"\u672a\u627e\u5230\u6d41\u7a0b\u5904\u7406\u5668");
        return null;
    }

    private void checkBpmParam() {
        if (StringUtils.isEmpty((Object)this.bpmContext.getOperator()) || this.bpmContext.getBusinessObject() == null) {
            Thrower.throwAppException((String)"0010", (String)"\u6d41\u7a0b\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
    }
}

