/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.bpm;

import com.tcbj.framework.bpm.BpmCondition;
import com.tcbj.framework.bpm.BpmContext;
import com.tcbj.framework.bpm.BpmNode;
import com.tcbj.framework.bpm.BpmTransition;
import com.tcbj.framework.bpm.SimpleBpmTransition;
import java.util.HashMap;
import java.util.Map;

public class ConditionalBpmTransition<T>
implements BpmTransition<T> {
    private Map<BpmCondition<T>, SimpleBpmTransition<T>> conditionMap = new HashMap<BpmCondition<T>, SimpleBpmTransition<T>>();

    private ConditionalBpmTransition() {
    }

    @Override
    public BpmNode<T> getNextNode(BpmContext<T> context) {
        for (BpmCondition<T> c : this.conditionMap.keySet()) {
            if (!c.match(context)) continue;
            return this.conditionMap.get(c).getNextNode(context);
        }
        return null;
    }

    private ConditionalBpmTransition(BpmCondition<T> condition, BpmNode<T> nextNode) {
        if (condition != null) {
            this.conditionMap.put(condition, SimpleBpmTransition.of(nextNode));
        }
    }

    public void add(BpmCondition<T> condition, BpmNode<T> nextNode) {
        this.conditionMap.put(condition, SimpleBpmTransition.of(nextNode));
    }

    public static <T> ConditionalBpmTransition<T> NEW() {
        return new ConditionalBpmTransition<T>();
    }
}

