package com.tcbj.framework.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ApiModel(value="分页类")
public class Page<T> implements Serializable {
	/**数据记录集**/
	@ApiModelProperty(value="具体数据集合")
	private List<T> data;
	
	/**页数**/
	@ApiModelProperty(value="页数")
	private int pageNo=1;
	
	/**每页大小**/
	@ApiModelProperty(value="每页行数")
	private int pageSize=10;
	
	/**总记录数**/
	@ApiModelProperty(value="总记录数")
	private int totalRecord;

	public Page(){
		this(1,10,0, Collections.emptyList());
	}
	
	public Page(int pageNo,int pageSize,int totalRecord,List<T> data){
		this.pageNo = pageNo;
		this.pageSize = pageSize;
		this.totalRecord = totalRecord;
		this.data = data;
	}
	
	/**
	 * 
	 *
	 * @Description 描述备注:获取总页数
	 * @return int 总页数 
	 * @author huanghj2
	 * @Date 2016年3月9日
	 */
	@ApiModelProperty(value="总页数")
	public int getTotalPage(){
		if (totalRecord % pageSize == 0)
			return totalRecord / pageSize;
		else
			return totalRecord / pageSize + 1;
	}
	
	public List<T> getData() {
		return data;
	}
	public void setData(List<T> data) {
		this.data = data;
	}
	public int getPageNo() {
		return pageNo;
	}
	public void setPageNo(int pageNo) {
		this.pageNo = pageNo;
	}
	public int getPageSize() {
		return pageSize;
	}
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
	public int getTotalRecord() {
		return totalRecord;
	}
	public void setTotalRecord(int totalRecord) {
		this.totalRecord = totalRecord;
	}
	
	public <E> Page<E> transformData(List<E> newData){
		Page<E> page = new Page<>(pageNo, pageSize, totalRecord, newData);
		return page;
	} 
}
