package com.tcbj.framework.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel(value="响应数据")
public class Response<T> extends DTO {

	public static enum StatusCode {
		SUCCESS("200"),NOT_FOUND("404"),VALID_ERROR("400"),ERROR("500"),AUTH_ERROR("401"),TOKEN_INVALID("402"),ACCESS_DENIED("403");
		private final String value;
		public String getValue() {
			return value;
		}
		StatusCode(String value) {
			this.value = value;
		}
	}

	public Response(){};

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value="错误码")
	private String code;
	@ApiModelProperty(value="错误消息")
	private String msg;
	@ApiModelProperty(value="请求是否成功")
	private boolean isSuccess;
	@ApiModelProperty(value="返回信息")
	private T data;

	private Response(Builder<T> builder){
		this.code = builder.code;
		this.msg = builder.msg;
		this.data = builder.data;
		if(builder.code.equals(StatusCode.SUCCESS.getValue())){
			this.isSuccess = true;
		}else{
			this.isSuccess = false;
		}

	}

	public String getCode() {
		return code;
	}

	public void setCode(String errorCode) {
		this.code = errorCode;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String errorMsg) {
		this.msg = errorMsg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public boolean isSuccess() {
		return isSuccess;
	}

	public void setSuccess(boolean isSuccess) {
		this.isSuccess = isSuccess;
	}

	public static <T> Response<T> buildSuccessResponse(T data){
		Response<T> r = new Builder<T>(StatusCode.SUCCESS.getValue()).msg("success").data(data).build();
		return r;
	}

	public static <T> Response<T> buildSysFailureResponse(T data){
		Response<T> r = new Builder<T>(StatusCode.ERROR.getValue()).msg("Sys Error").data(data).build();
		return r;
	}

	public static <T> Response<T> build404Response(T data){
		Response<T> r = new Builder<T>(StatusCode.NOT_FOUND.getValue()).msg("Resource not found").data(data).build();
		return r;
	}

	public static <T> Response<T> buildValidErrorResponse(String validMessage){
		Response<T> r = new Builder<T>(StatusCode.VALID_ERROR.getValue()).msg(validMessage).build();
		return r;
	}

	public static <T> Response<T> buildBizzFailureResponse(String errorCode,String errorMsg,T data){
		Response<T> r = new Builder<T>(errorCode).code(errorCode).msg(errorMsg).data(data).build();
		return r;
	}

	public static class Builder<T>{
		private String code;
		private String msg;
		private T data;

		public Builder(String code){
			this.code = code;
		}

		public Builder<T> code(String code){
			this.code = code;
			return this;
		}

		public Builder<T> msg(String msg){
			this.msg = msg;
			return this;
		}


		public Builder<T> data(T data){
			this.data = data;
			return this;
		}

		public Response<T> build(){
			return new Response<T>(this);
		}

		public Response<T> build404(){
			return new Response<T>(this);
		}

	}

}
