/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.ms.loadbalance.nacos;

import com.tcbj.framework.ms.loadbalance.contract.TcbjLoadbalanceEnum;
import com.tcbj.framework.ms.loadbalance.nacos.VersionHeaderHolder;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class VersionMetadataLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionMetadataLoadBalancer.class);
    private final String serviceId;
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;

    public VersionMetadataLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId) {
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> this.processInstanceResponse(supplier, (List<ServiceInstance>)serviceInstances, request));
    }

    private Response<ServiceInstance> processInstanceResponse(ServiceInstanceListSupplier supplier, List<ServiceInstance> instances, Request request) {
        ServiceInstance selected;
        List<Object> filteredInstances;
        if (instances.isEmpty()) {
            LOGGER.warn("No servers available for service: {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        String version = this.extractVersion(request);
        LOGGER.debug("Extracted version from request: {}", (Object)version);
        if (version != null && !version.trim().isEmpty()) {
            filteredInstances = instances.stream().filter(instance -> version.equals(instance.getMetadata().get(TcbjLoadbalanceEnum.HEAD_INDICATOR))).collect(Collectors.toList());
            LOGGER.debug("Found {} instances matching version {}", (Object)filteredInstances.size(), (Object)version);
            if (filteredInstances.isEmpty()) {
                LOGGER.debug("No instances found for version {}, falling back to unversioned instances", (Object)version);
                filteredInstances = instances.stream().filter(instance -> instance.getMetadata().get(TcbjLoadbalanceEnum.HEAD_INDICATOR) == null).collect(Collectors.toList());
            }
        } else {
            filteredInstances = instances.stream().filter(instance -> instance.getMetadata().get(TcbjLoadbalanceEnum.HEAD_INDICATOR) == null).collect(Collectors.toList());
            LOGGER.debug("No version specified, found {} unversioned instances", (Object)filteredInstances.size());
        }
        if (filteredInstances.isEmpty()) {
            LOGGER.debug("No filtered instances available, using all instances");
            filteredInstances = instances;
        }
        if ((selected = this.randomChoose(filteredInstances)) != null) {
            LOGGER.debug("Selected instance: {}:{}", (Object)selected.getHost(), (Object)selected.getPort());
            if (supplier instanceof SelectedInstanceCallback) {
                ((SelectedInstanceCallback)supplier).selectedServiceInstance(selected);
            }
            return new DefaultResponse(selected);
        }
        return new EmptyResponse();
    }

    private String extractVersion(Request request) {
        List versions;
        RequestDataContext context;
        String version = VersionHeaderHolder.getVersion();
        if (version != null && !version.isEmpty()) {
            return version;
        }
        if (request != null && request.getContext() instanceof RequestDataContext && (context = (RequestDataContext)request.getContext()).getClientRequest() != null && context.getClientRequest().getHeaders() != null && (versions = context.getClientRequest().getHeaders().get((Object)TcbjLoadbalanceEnum.HEAD_INDICATOR)) != null && !versions.isEmpty()) {
            return (String)versions.get(0);
        }
        return null;
    }

    private ServiceInstance randomChoose(List<ServiceInstance> instances) {
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        int index = ThreadLocalRandom.current().nextInt(instances.size());
        return instances.get(index);
    }
}

