/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.framework.util.excel;

import com.tcbj.framework.util.excel.ExcelExportHandler;
import com.tcbj.framework.util.excel.ExcelResultWriter;
import com.tcbj.framework.util.excel.ExcelVersion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelCreator<T> {
    private ExcelVersion version;
    private List<T> data;
    private String sheetName;
    private String[] titles;
    private String[] props;
    private ExcelExportHandler<T> handler;

    public ExcelCreator(ExcelVersion version) {
        this.version = version;
    }

    public static ExcelCreator New2003() {
        return new ExcelCreator(ExcelVersion.EXCEL_2003);
    }

    public static ExcelCreator New2007() {
        return new ExcelCreator(ExcelVersion.EXCEL_2007);
    }

    public ExcelCreator titles(String[] titles) {
        this.titles = titles;
        return this;
    }

    public ExcelCreator props(String[] props) {
        this.props = props;
        return this;
    }

    public ExcelCreator handler(ExcelExportHandler handler) {
        this.handler = handler;
        return this;
    }

    public ExcelCreator sheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public ExcelResultWriter create() throws Exception {
        int i;
        Workbook workbook = this.getWorkbook(this.version);
        Sheet sheet = workbook.createSheet(this.sheetName);
        Row row = sheet.createRow(0);
        for (i = 0; i < this.titles.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(this.titles[i]);
        }
        for (i = 0; i < this.data.size(); ++i) {
            boolean isMap;
            row = sheet.createRow(i + 1);
            T obj = this.data.get(i);
            if (this.handler != null) {
                this.handler.invoke(obj);
            }
            boolean bl = isMap = Map.class.isAssignableFrom(obj.getClass());
            if (isMap) {
                Map map = (Map)obj;
                List<String> prop = Arrays.asList(this.props);
                for (int j = 0; j < prop.size(); ++j) {
                    Cell cell = row.createCell(j);
                    Object result = map.get(prop.get(j));
                    cell.setCellValue(result == null ? "" : result.toString());
                }
                continue;
            }
            List<String> prop = Arrays.asList(this.props);
            for (int j = 0; j < prop.size(); ++j) {
                Cell cell = row.createCell(j);
                Object result = this.getPropValue(obj.getClass(), obj, prop.get(j));
                cell.setCellValue(result == null ? "" : result.toString());
            }
        }
        ExcelResultWriter writer = new ExcelResultWriter(workbook);
        return writer;
    }

    private Workbook getWorkbook(ExcelVersion version) throws Exception {
        HSSFWorkbook wb = null;
        if (ExcelVersion.EXCEL_2003 == version) {
            wb = new HSSFWorkbook();
        } else if (ExcelVersion.EXCEL_2007 == version) {
            wb = new XSSFWorkbook();
        } else {
            throw new RuntimeException("Unsuport version of the excel type");
        }
        return wb;
    }

    private Object getPropValue(Class clazz, Object obj, String prop) throws Exception {
        String getName = "get" + prop.substring(0, 1).toUpperCase(Locale.ENGLISH) + prop.substring(1);
        Method rM = clazz.getMethod(getName, new Class[0]);
        return rM.invoke(obj, new Object[0]);
    }
}

