/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.basedata.api.rpc;

import com.tcbj.framework.dto.Page;
import com.tcbj.framework.dto.Response;
import com.tcbj.tangsales.basedata.api.contract.request.ProductQuery;
import com.tcbj.tangsales.basedata.api.contract.response.product.PartnerProductDto;
import com.tcbj.tangsales.basedata.api.contract.response.product.ProductDto;
import com.tcbj.tangsales.basedata.api.contract.response.product.ProductLabelDto;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="tang-sales-basedata-module-service", path="/api/basedata/product")
public interface ProductApi {
    @GetMapping(value={"/get"})
    public Response<ProductDto> getProduct(@RequestParam(name="id") String var1);

    @PostMapping(value={"/list"})
    public Response<List<ProductDto>> queryProductList(@RequestBody ProductQuery var1);

    @PostMapping(value={"/queryProduct"})
    public Response<ProductDto> queryProduct(@RequestBody ProductQuery var1);

    @PostMapping(value={"/getSimple"})
    public Response<ProductDto> getSimpleProduct(@RequestParam(name="id") String var1);

    @PostMapping(value={"/getLabel"})
    public Response<List<ProductLabelDto>> getLabel(@RequestParam(name="type") String var1);

    @PostMapping(value={"/queryPartnerProductList"})
    public Response<List<PartnerProductDto>> queryPartnerProductList(@RequestBody ProductQuery var1);

    @PostMapping(value={"/queryPartnerProductPage"})
    public Response<Page<PartnerProductDto>> queryPartnerProductPage(@RequestBody ProductQuery var1);

    @GetMapping(value={"/getProductById"})
    public Response<ProductDto> getProductById(@RequestParam(name="id") String var1);

    @GetMapping(value={"/getRecommendProductTop10"})
    public Response<List<String>> getRecommendProductTop10();
}

