/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.common.operator;

import com.tcbj.framework.web.util.DynamicTimeoutInterceptor;
import com.tcbj.tangsales.common.operator.OkHttpLoggingInterceptor;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class OkHttpConfig
implements RequestInterceptor {
    public void apply(RequestTemplate template) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String values = request.getHeader(name);
                template.header(name, new String[]{values});
            }
        }
    }

    @Bean
    public OkHttpClient.Builder okHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new DynamicTimeoutInterceptor());
        builder.addInterceptor((Interceptor)new OkHttpLoggingInterceptor());
        return builder;
    }
}

