/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.tangsales.common.operator;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpLoggingInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(OkHttpLoggingInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        logger.info(String.format("\u53d1\u9001\u8bf7\u6c42 %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        ResponseBody responseBody = response.peekBody(0x100000L);
        logger.info(String.format("\u63a5\u6536\u54cd\u5e94: [%s] %n\u8fd4\u56dejson:\u3010%s\u3011 %.1fms%n%s", response.request().url(), responseBody.string(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

