/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.yxy.framework.dubbo.listener;

import com.tcbj.yxy.framework.dubbo.ProviderInfo;
import com.tcbj.yxy.framework.exception.exception.AppException;
import com.tcbj.yxy.framework.message.MessageFactory;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class AppExceptionListener
implements Filter.Listener {
    private static Logger log = LoggerFactory.getLogger(AppExceptionListener.class);

    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (result.hasException() && GenericService.class != invoker.getInterface()) {
            try {
                Throwable exception = result.getException();
                ProviderInfo providerInfo = AppExceptionListener.buildProviderInfo(invocation);
                log.error("exception error: ", exception);
                log.error("providerInfo: " + providerInfo);
                if (exception instanceof AppException) {
                    return;
                }
                if (exception instanceof ConstraintViolationException) {
                    ConstraintViolationException cve = (ConstraintViolationException)exception;
                    String message = "";
                    for (ConstraintViolation vio : cve.getConstraintViolations()) {
                        String msg;
                        message = msg = MessageFactory.getMessageSource().getMessage(vio.getMessage());
                    }
                    result.setException((Throwable)new AppException("400", message));
                    return;
                }
                if (exception instanceof MethodArgumentNotValidException) {
                    MethodArgumentNotValidException manve = (MethodArgumentNotValidException)exception;
                    String message = "";
                    for (FieldError fieldError : manve.getBindingResult().getFieldErrors()) {
                        String msg;
                        message = msg = MessageFactory.getMessageSource().getMessage(fieldError.getDefaultMessage());
                    }
                    result.setException((Throwable)new AppException("400", message));
                    return;
                }
                result.setException((Throwable)new AppException("500", "rpc call exception"));
                return;
            }
            catch (Throwable e) {
                log.warn("Fail to DubboExceptionFilter when called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
                return;
            }
        }
    }

    private static ProviderInfo buildProviderInfo(Invocation invocation) {
        RpcContext context = RpcContext.getContext();
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.setLocalAddress(context.getLocalAddressString());
        providerInfo.setRemoteAddress(context.getRemoteAddressString());
        providerInfo.setApplicationName(context.getUrl().getParameter("application"));
        providerInfo.setMethodName(invocation.getMethodName());
        providerInfo.setAttachments(invocation.getAttachments());
        return providerInfo;
    }

    public void onError(Throwable throwable, Invoker<?> invoker, Invocation invocation) {
        log.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + throwable.getClass().getName() + ": " + throwable.getMessage(), throwable);
    }
}

