/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.yxy.framework.web.converter;

import com.tcbj.yxy.framework.web.converter.DateConverterEditor;
import com.tcbj.yxy.framework.web.converter.NumberConvertEditor;
import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;

@Configuration
public class ConverterConfig {
    @Autowired
    Validator mvcValidator;

    @Bean(name={"myConversionService"})
    public ConversionService conversionService() {
        FormattingConversionServiceFactoryBean convertService = new FormattingConversionServiceFactoryBean();
        convertService.setRegisterDefaultFormatters(true);
        convertService.afterPropertiesSet();
        return convertService.getObject();
    }

    @Bean(name={"webBindingInitializer"})
    public ConfigurableWebBindingInitializer webBindingInitializer() {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService(this.conversionService());
        initializer.setValidator(this.mvcValidator);
        return initializer;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Byte.TYPE, (PropertyEditor)new NumberConvertEditor(Byte.class));
        binder.registerCustomEditor(Byte.class, (PropertyEditor)new NumberConvertEditor(Byte.TYPE));
        binder.registerCustomEditor(Short.TYPE, (PropertyEditor)new NumberConvertEditor(Short.TYPE));
        binder.registerCustomEditor(Short.class, (PropertyEditor)new NumberConvertEditor(Short.class));
        binder.registerCustomEditor(Integer.TYPE, (PropertyEditor)new NumberConvertEditor(Integer.TYPE));
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new NumberConvertEditor(Integer.class));
        binder.registerCustomEditor(Long.TYPE, (PropertyEditor)new NumberConvertEditor(Long.TYPE));
        binder.registerCustomEditor(Long.class, (PropertyEditor)new NumberConvertEditor(Long.class));
        binder.registerCustomEditor(Float.TYPE, (PropertyEditor)new NumberConvertEditor(Float.TYPE));
        binder.registerCustomEditor(Float.class, (PropertyEditor)new NumberConvertEditor(Float.class));
        binder.registerCustomEditor(Double.TYPE, (PropertyEditor)new NumberConvertEditor(Double.TYPE));
        binder.registerCustomEditor(Double.class, (PropertyEditor)new NumberConvertEditor(Double.class));
        binder.registerCustomEditor(BigDecimal.class, (PropertyEditor)new NumberConvertEditor(BigDecimal.class));
        binder.registerCustomEditor(BigInteger.class, (PropertyEditor)new NumberConvertEditor(BigInteger.class));
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DateConverterEditor());
    }
}

