/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.yxy.framework.web.converter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class ConverterToDate
implements Converter<String, Date> {
    private static final List<String> formarts = new ArrayList<String>(4);
    private static final String YYYY_MM = "yyyy-MM";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public Date convert(String source) {
        if (StringUtils.isEmpty((Object)source)) {
            return null;
        }
        if ((source = source.trim()).matches("^\\d{4}-\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(0));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(1));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(2));
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            return this.parseDate(source, formarts.get(3));
        }
        throw new IllegalArgumentException("Invalid false value '" + source + "'");
    }

    private Date parseDate(String dateStr, String format) {
        Date date;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return date;
    }

    static {
        formarts.add(YYYY_MM);
        formarts.add(YYYY_MM_DD);
        formarts.add(YYYY_MM_DD_HH_MM);
        formarts.add(YYYY_MM_DD_HH_MM_SS);
    }
}

