/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.yxy.framework.web.exception;

import com.tcbj.yxy.framework.dto.Response;
import com.tcbj.yxy.framework.exception.exception.AppException;
import com.tcbj.yxy.framework.message.MessageFactory;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

public class RestResponseEntityExceptionHandler {
    @ExceptionHandler(value={NoHandlerFoundException.class})
    protected ResponseEntity<Object> handle404(NoHandlerFoundException ex) {
        Response r = Response.build404Response(null);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={AppException.class})
    protected ResponseEntity<Object> handleBizz(AppException ex) {
        Response r = Response.buildBizzFailureResponse((String)ex.getErrorCode(), (String)ex.getErrorMsg(), null);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handle500(Exception ex) {
        Response r = Response.buildSysFailureResponse(null);
        ex.printStackTrace();
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleFormValidate(ConstraintViolationException ex) {
        String message = "";
        for (ConstraintViolation vio : ex.getConstraintViolations()) {
            String msg;
            message = msg = MessageFactory.getMessageSource().getMessage(vio.getMessage());
        }
        Response r = Response.buildValidErrorResponse((String)message);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={BindException.class})
    protected ResponseEntity<Object> handleFormValidate(BindException ex) {
        String message = "";
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            String msg;
            message = msg = MessageFactory.getMessageSource().getMessage(fieldError.getDefaultMessage());
        }
        Response r = Response.buildValidErrorResponse((String)message);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ResponseEntity<Object> handleJsonValidate(MethodArgumentNotValidException ex) {
        String message = "";
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            String msg;
            message = msg = MessageFactory.getMessageSource().getMessage(fieldError.getDefaultMessage());
        }
        Response r = Response.buildValidErrorResponse((String)message);
        return new ResponseEntity((Object)r, HttpStatus.OK);
    }
}

