/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.yxy.orderReturn.domain.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.tcbj.util.Beans;
import java.util.stream.Stream;

public interface OrderReturnEnum {
    public static final String FIXED_TAX_RATE = "17";

    public static enum OrderReturnSource {
        HAND_MADE("\u624b\u5de5"),
        MINI_PROGRAM("\u5c0f\u7a0b\u5e8f"),
        PURCHASE_SELL_STOCK("\u8fdb\u9500\u5b58");

        @JsonValue
        private final String value;

        public static OrderReturnSource of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(OrderReturnSource.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private OrderReturnSource(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ReturnType {
        NORMAL_RETURN("NORMAL_RETURN", "\u6b63\u5e38\u9000\u8d27");

        @JsonValue
        private final String value;
        private final String desc;

        public static ReturnType of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(ReturnType.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private ReturnType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum OrderReturnType {
        NORMAL_RETURN("NORMAL_RETURN", "\u666e\u901a\u9000\u8d27"),
        DIRECT_RETURN("DIRECT_RETURN", "\u76f4\u8fd0\u9000\u8d27"),
        GOODCOMM_RETURN("GOODCOMM_RETURN", "\u4ee3\u9500\u9000\u8d27");

        @JsonValue
        private final String value;
        private final String desc;

        public static OrderReturnType of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(OrderReturnType.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private OrderReturnType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum SettlementMode {
        YJXY("YJXY", "\u6708\u7ed3+\u4fe1\u7528"),
        XK("XK", "\u73b0\u6b3e"),
        XY("XY", "\u4fe1\u7528"),
        YJ("YJ", "\u6708\u7ed3");

        @JsonValue
        private final String value;
        private final String desc;

        public static SettlementMode of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(SettlementMode.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private SettlementMode(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum ShipmentType {
        SEF_PICK("SEF_PICK", "\u81ea\u63d0"),
        FREIGHT("FREIGHT", "\u8d27\u8fd0"),
        DELIVERY("DELIVERY", "\u9001\u8d27");

        @JsonValue
        private final String value;
        private final String desc;

        public static ShipmentType of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(ShipmentType.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private ShipmentType(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum ShipmentPriority {
        MIDDLE("MIDDLE", "\u4e2d"),
        HIGH("HIGH", "\u9ad8"),
        LOW("LOW", "\u4f4e");

        @JsonValue
        private final String value;
        private final String desc;

        public static ShipmentPriority of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(ShipmentPriority.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private ShipmentPriority(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum EnableStatus {
        NO("0", "\u5426"),
        YES("1", "\u662f");

        @JsonValue
        private final String value;
        private final String desc;

        public static EnableStatus of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(EnableStatus.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private EnableStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum OrderReturnStatus {
        draft("0", "\u8349\u7a3f"),
        audit("1", "\u5df2\u63d0\u4ea4"),
        approveNoPass("2-0", "\u5ba1\u6279\u4e0d\u901a\u8fc7"),
        approvePass("2", "\u5df2\u5ba1\u6279"),
        waitVerify("3", "\u5f85\u6838\u5b9e"),
        verified("4", "\u5df2\u6838\u5b9e"),
        sended("5", "\u5df2\u53d1\u8d27"),
        received("6", "\u5df2\u6536\u8d27"),
        delete("9", "\u5df2\u5220\u9664");

        @JsonValue
        private final String value;
        private final String desc;

        public static OrderReturnStatus of(String value) {
            if (Beans.isEmpty((Object)value)) {
                return null;
            }
            return Stream.of(OrderReturnStatus.values()).filter(item -> item.value.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException(value + " not exists!"));
        }

        private OrderReturnStatus(String value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

