/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00Entry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftChuLDAPLogSchema00DeleteEntry
extends DraftChuLDAPLogSchema00Entry {
    public static final String ATTR_DELETED_ATTRIBUTE = "reqOld";
    private static final long serialVersionUID = -4326357861964770357L;
    private final List<Attribute> deletedAttributes;

    public DraftChuLDAPLogSchema00DeleteEntry(Entry entry) throws LDAPException {
        super(entry, OperationType.DELETE);
        byte[][] deletedAttrBytes = entry.getAttributeValueByteArrays(ATTR_DELETED_ATTRIBUTE);
        if (deletedAttrBytes == null || deletedAttrBytes.length == 0) {
            this.deletedAttributes = Collections.emptyList();
            return;
        }
        LinkedHashMap attrMap = new LinkedHashMap(deletedAttrBytes.length);
        for (byte[] attrBytes : deletedAttrBytes) {
            byte[] attrValue;
            int colonPos = -1;
            for (int i = 0; i < attrBytes.length; ++i) {
                if (attrBytes[i] != 58) continue;
                colonPos = i;
                break;
            }
            if (colonPos < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_DELETE_OLD_ATTR_MISSING_COLON.get(entry.getDN(), ATTR_DELETED_ATTRIBUTE, StaticUtils.toUTF8String(attrBytes)));
            }
            if (colonPos == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_DELETE_OLD_ATTR_MISSING_ATTR.get(entry.getDN(), ATTR_DELETED_ATTRIBUTE, StaticUtils.toUTF8String(attrBytes)));
            }
            if (colonPos == attrBytes.length - 1 || attrBytes[colonPos + 1] != 32) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_DELETE_OLD_ATTR_MISSING_SPACE.get(entry.getDN(), ATTR_DELETED_ATTRIBUTE, StaticUtils.toUTF8String(attrBytes)));
            }
            String attrName = StaticUtils.toUTF8String(attrBytes, 0, colonPos);
            String lowerName = StaticUtils.toLowerCase(attrName);
            ArrayList<Attribute> attrList = (ArrayList<Attribute>)attrMap.get(lowerName);
            if (attrList == null) {
                attrList = new ArrayList<Attribute>(10);
                attrMap.put(lowerName, attrList);
            }
            if ((attrValue = new byte[attrBytes.length - colonPos - 2]).length > 0) {
                System.arraycopy(attrBytes, colonPos + 2, attrValue, 0, attrValue.length);
            }
            attrList.add(new Attribute(attrName, attrValue));
        }
        ArrayList<Attribute> oldAttributes = new ArrayList<Attribute>(attrMap.size());
        for (List attrList : attrMap.values()) {
            if (attrList.size() == 1) {
                oldAttributes.addAll(attrList);
                continue;
            }
            byte[][] valueArray = new byte[attrList.size()][];
            for (int i = 0; i < attrList.size(); ++i) {
                valueArray[i] = ((Attribute)attrList.get(i)).getValueByteArray();
            }
            oldAttributes.add(new Attribute(((Attribute)attrList.get(0)).getName(), valueArray));
        }
        this.deletedAttributes = Collections.unmodifiableList(oldAttributes);
    }

    public List<Attribute> getDeletedAttributes() {
        return this.deletedAttributes;
    }

    public DeleteRequest toDeleteRequest() {
        return new DeleteRequest(this.getTargetEntryDN(), this.getRequestControlArray());
    }
}

