/*
 * Decompiled with CFR 0.152.
 */
package com.vicutu.center.channel.api.exception;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

public class ChannelExceptionHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FAIL_CODE = "100000";
    public static final String MSG_SYSTEM_ERROR = "\u6e20\u9053\u4e2d\u5fc3\u670d\u52a1\u5f00\u5c0f\u5dee\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
    public static final String MSG_INVALID_PARAM = "\u65e0\u6548\u7684\u8bf7\u6c42\u53c2\u6570";

    @ExceptionHandler(value={Exception.class})
    RestResponse handleException(Exception ex) {
        if (ex instanceof UndeclaredThrowableException) {
            return this.fail("\u670d\u52a1\u4e0d\u53ef\u7528");
        }
        if (ex instanceof BindException) {
            String msg = this.getBindErrorMsg((BindingResult)ex);
            return this.fail(msg.replaceAll("Exception.*?]", ""));
        }
        if (ex instanceof MethodArgumentNotValidException) {
            List allErrors = ((MethodArgumentNotValidException)ex).getBindingResult().getAllErrors();
            ObjectError objectError = (ObjectError)allErrors.get(0);
            return this.fail(objectError.getDefaultMessage().replaceAll("Exception.*?]", ""));
        }
        this.logger.error("", (Throwable)ex);
        return this.fail(MSG_SYSTEM_ERROR);
    }

    public String getBindErrorMsg(BindingResult bindingResult) {
        if (bindingResult != null && bindingResult.hasErrors()) {
            List errorList = bindingResult.getAllErrors();
            ObjectError error = (ObjectError)errorList.get(0);
            return error.getDefaultMessage();
        }
        return MSG_SYSTEM_ERROR;
    }

    protected RestResponse fail(String msg) {
        return new RestResponse(FAIL_CODE, msg);
    }

    @ExceptionHandler(value={BusinessRuntimeException.class})
    RestResponse handleBusinessException(BusinessRuntimeException e) {
        this.logger.error("\u4e1a\u52a1\u5f02\u5e38===>", (Throwable)e);
        return new RestResponse(e.getCode(), e.getRawMessage());
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isBlank((CharSequence)text)) {
                    this.setValue(null);
                } else {
                    Date parse = null;
                    if (ChannelExceptionHandler.this.isValidDate(text, DatePattern.DATETIME_PATTERN.getPattern())) {
                        parse = DateUtil.parse((String)text, (String)DatePattern.DATETIME_PATTERN.getPattern());
                    } else if (ChannelExceptionHandler.this.isValidDate(text, DatePattern.DATETIME_PATTERN_HHMM.getPattern())) {
                        parse = DateUtil.parse((String)text, (String)DatePattern.DATETIME_PATTERN_HHMM.getPattern());
                    } else if (ChannelExceptionHandler.this.isValidDate(text, DatePattern.DATE_PATTERN.getPattern())) {
                        parse = DateUtil.parse((String)text, (String)DatePattern.DATE_PATTERN.getPattern());
                    }
                    this.setValue(parse);
                }
                ChannelExceptionHandler.this.logger.info("\u65e5\u671f\u683c\u5f0f\u503c\uff1a{}", (Object)text);
            }
        });
    }

    public boolean isValidDate(String text, String pattern) {
        boolean result = true;
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setLenient(false);
        try {
            format.parse(text);
        }
        catch (ParseException e) {
            result = false;
        }
        return result;
    }
}

