/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.config;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.wh.commons.annotations.DistributedLock;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Order(value=-2147483648)
public abstract class AbstractRedisLockAspect {
    private final ExpressionParser parser = new SpelExpressionParser();
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisLockAspect.class);

    protected abstract ILockService getLockService();

    @Pointcut(value="@annotation(com.wh.commons.annotations.DistributedLock)")
    public void pointCut() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) {
        Object object;
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        String className = point.getTarget().getClass().getName();
        Object[] args = point.getArgs();
        String[] paramNames = signature.getParameterNames();
        StandardEvaluationContext context = new StandardEvaluationContext();
        int i = 0;
        while (true) {
            block8: {
                if (i < args.length) break block8;
            }
            context.setVariable(paramNames[i], args[i]);
            ++i;
        }
        DistributedLock lock = method.getAnnotation(DistributedLock.class);
        String param = StrUtil.isBlank((CharSequence)lock.key()) ? method.getName() : (String)this.parser.parseExpression(lock.key()).getValue((EvaluationContext)context, String.class);
        String lockName = StrUtil.isBlank((CharSequence)lock.lockName()) ? className : lock.lockName();
        Mutex mutex = null;
        try {
            log.info("AOP>>>>\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f, lockName={}, param={}, waitTimeOut={}, leaseTime={}", new Object[]{lockName, param, lock.waitTimeOut(), lock.leaseTime()});
            mutex = this.getLockService().lock(lockName, param, lock.waitTimeOut(), lock.leaseTime(), lock.timeUnit());
            log.info("AOP>>>>\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f, \u6267\u884c\u65b9\u6cd5\u4f53\u5f00\u59cb>>>>key:{}", (Object)param);
            Object proceed = point.proceed();
            log.info("AOP>>>>\u6267\u884c\u65b9\u6cd5\u4f53\u7ed3\u675f>>>>key:{}", (Object)param);
            object = proceed;
        }
        catch (BizException e) {
            try {
                log.error("\u5206\u5e03\u5f0f\u9501AOP\u6267\u884c\u5f02\u5e38BizException", (Throwable)e);
                throw e;
                catch (Throwable e2) {
                    log.error("\u5206\u5e03\u5f0f\u9501AOP\u6267\u884c\u5f02\u5e38Exception", e2);
                    throw new BizException("\u4e1a\u52a1\u5f02\u5e38\u7a0d\u540e\u518d\u8bd5: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                log.info("\u5206\u5e03\u5f0f\u9501AOP\u6267\u884c\u5b8c\u6210>>>>");
                if (ObjectUtil.isNotEmpty(mutex)) {
                    this.getLockService().unlock(mutex);
                    log.info("\u5206\u5e03\u5f0f\u9501AOP\u6267\u884c\u5b8c\u6210>>>>\u91ca\u653e\u9501\u5b8c\u6210>>>key:{}", (Object)param);
                }
                throw throwable;
            }
        }
        log.info("\u5206\u5e03\u5f0f\u9501AOP\u6267\u884c\u5b8c\u6210>>>>");
        if (ObjectUtil.isNotEmpty((Object)mutex)) {
            this.getLockService().unlock(mutex);
            log.info("\u5206\u5e03\u5f0f\u9501AOP\u6267\u884c\u5b8c\u6210>>>>\u91ca\u653e\u9501\u5b8c\u6210>>>key:{}", (Object)param);
        }
        return object;
    }
}

