/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.config;

import com.dtyunxi.cube.commons.beans.ApiResult;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.commons.exceptions.ValidateException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice(annotations={RestController.class})
@Order(value=1)
public class ApiCustomExceptionAdvice {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult handleBindExceptionException(BindException ex) {
        ApiResult apiResult = this.extractMsg(ex.getBindingResult());
        return this.makeResult(apiResult.getResultCode(), ex.getMessage() == null ? "\u6570\u636e\u7ed1\u5b9a\u5f02\u5e38" : apiResult.getResultMsg(), null);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult handleMethodArgumentException(MethodArgumentNotValidException ex) {
        ApiResult apiResult = this.extractMsg(ex.getBindingResult());
        return this.makeResult(apiResult.getResultCode(), ex.getMessage() == null ? "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38" : apiResult.getResultMsg(), null);
    }

    @ExceptionHandler(value={com.dtyunxi.exceptions.BizException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult<Object> handleBizException(com.dtyunxi.exceptions.BizException ex) {
        this.LOGGER.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ex.getCode(), ex.getMessage() == null ? "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38" : ex.getMessage(), null);
    }

    @ExceptionHandler(value={BizException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult<Object> handleBizException(BizException ex) {
        this.LOGGER.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ex.getCode(), ex.getMessage() == null ? "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38" : ex.getMessage(), null);
    }

    @ExceptionHandler(value={DataAccessException.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult handleAllException(DataAccessException ex) {
        this.LOGGER.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ExceptionCode.DAO_ERR.getCode(), ExceptionCode.DAO_ERR.getMsg(), null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ApiResult handleAllException(Exception ex) {
        this.LOGGER.error(ex.getMessage(), (Throwable)ex);
        return this.makeResult(ExceptionCode.SYSTEM_ERR.getCode(), ex.getMessage() == null ? ExceptionCode.SYSTEM_ERR.getMsg() : ex.getMessage(), null);
    }

    private ApiResult extractMsg(BindingResult bindingResult) {
        ValidateException vex = new ValidateException();
        if (bindingResult.hasFieldErrors()) {
            List errors = bindingResult.getFieldErrors();
            for (FieldError err : errors) {
                vex.addError(err.getField(), err.getDefaultMessage());
            }
        }
        this.LOGGER.error("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a{}", (Object)vex.getMessage());
        return this.makeResult(vex.getCode(), vex.getMessage(), vex.getErrors());
    }

    public <T> ApiResult<T> makeResult(String code, String msg, T res) {
        return new ApiResult(code, msg, res);
    }

    public <T> ApiResult<T> makeResult(ExceptionCode status, T res) {
        return new ApiResult(status.getCode(), status.getMsg(), res);
    }

    public <T> ApiResult<T> makeResult(ExceptionCode status, String detail) {
        return new ApiResult(status.getCode(), String.valueOf(status.getMsg()) + "\uff1a" + detail, null);
    }
}

