/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.config;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.MD5Util;
import com.wh.commons.annotations.RepeatData;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RepeatDataAspect {
    private static final Logger logger = LoggerFactory.getLogger(RepeatDataAspect.class);
    public static final String UNDER_LINE = "_";
    public static final String FAIL_RESULT_CODE = "909090";
    @Resource
    private ICacheService cacheService;

    @Pointcut(value="@annotation(com.wh.commons.annotations.RepeatData)")
    public void repeatDataPoint() {
    }

    @Around(value="repeatDataPoint()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        logger.info("=======================\u5f00\u59cb\u91cd\u590d\u63d0\u4ea4\u5224\u65ad=======================");
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String url = request.getRequestURI();
        String method = request.getMethod();
        Long userId = ServiceContext.getContext().getRequestUserId();
        Object[] args = pjp.getArgs();
        String requestParam = JacksonUtil.toJson((Object)args[0]);
        logger.info("=======================\u3010url:{} \u3011====================", (Object)url);
        logger.info("=======================\u3010userId:{} \u3011====================", (Object)userId);
        logger.info("=======================\u3010request_way:{} \u3011====================", (Object)method);
        logger.info("=======================\u3010request_param:{} \u3011====================", (Object)requestParam);
        String key = MD5Util.getMd5ByString((String)(userId + UNDER_LINE + url + UNDER_LINE + method + UNDER_LINE + requestParam));
        logger.info("\u3010{}\u3011", (Object)key);
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        RepeatData repeatData = signature.getMethod().getAnnotation(RepeatData.class);
        if (this.cacheService.getCache(key, Integer.class) == null) {
            try {
                this.cacheService.setCache(key, (Object)1, repeatData.expireTime());
                return pjp.proceed();
            }
            catch (Exception e) {
                logger.error(String.valueOf(url) + " \u63a5\u53e3\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                this.cacheService.delCache(key);
                throw new BizException(e.getMessage());
            }
        }
        String msg = String.format("\u5f53\u524d\u7528\u6237\u3010%d\u3011\u8c03\u7528\u65b9\u6cd5\u3010%s\u3011\u51fa\u73b0\u91cd\u590d\u63d0\u4ea4", userId, method);
        logger.error(msg);
        throw new BizException(FAIL_RESULT_CODE, repeatData.expireMsg());
    }
}

