/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum OrgFrontTypeEnum {
    HQ_FRONT(1, "\u4e07\u548c\u603b\u90e8"),
    PLATFORM_FRONT(2, "\u5e73\u53f0\u516c\u53f8\u666e\u901a\u5458\u5de5"),
    OPERATORS_FRONT(3, "\u8fd0\u8425\u5546\u6216\u8fd0\u8425\u56e2\u961f"),
    OTHER_FRONT(4, "\u5176\u4ed6"),
    OPERATION_PERSONNEL(10, "\u8fd0\u8425\u4eba\u5458"),
    SALESMAN(11, "\u4e1a\u52a1\u5458");

    private Integer orgFrontLevel;
    private String orgFrontName;
    private static Map<Integer, String> OrgFrontTypeMap;

    static {
        OrgFrontTypeMap = new HashMap<Integer, String>();
        OrgFrontTypeEnum[] orgFrontTypeEnumArray = OrgFrontTypeEnum.values();
        int n = orgFrontTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OrgFrontTypeEnum orgType = orgFrontTypeEnumArray[n2];
            OrgFrontTypeMap.put(orgType.getOrgFrontLevel(), orgType.getOrgFrontName());
            ++n2;
        }
    }

    private OrgFrontTypeEnum(Integer orgFrontLevel, String orgFrontName) {
        this.orgFrontLevel = orgFrontLevel;
        this.orgFrontName = orgFrontName;
    }

    public static String getName(Integer code) {
        if (OrgFrontTypeMap.containsKey(code)) {
            return OrgFrontTypeMap.get(code);
        }
        return "";
    }

    public Integer getOrgFrontLevel() {
        return this.orgFrontLevel;
    }

    public void setOrgFrontLevel(Integer orgFrontLevel) {
        this.orgFrontLevel = orgFrontLevel;
    }

    public String getOrgFrontName() {
        return this.orgFrontName;
    }

    public void setOrgFrontName(String orgFrontName) {
        this.orgFrontName = orgFrontName;
    }

    public static Map<String, String> getAll() {
        HashMap<String, String> result = new HashMap<String, String>();
        Arrays.stream(OrgFrontTypeEnum.values()).forEach(e -> result.put(String.valueOf(e.getOrgFrontLevel()), e.getOrgFrontName()));
        return result;
    }
}

