/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.feign;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import feign.FeignException;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class FeignResultDecoder
implements Decoder,
InitializingBean {
    private Decoder decoder;
    @Autowired
    private ObjectFactory<HttpMessageConverters> messageConverters;

    public void afterPropertiesSet() throws Exception {
        if (this.decoder == null) {
            this.decoder = new SpringDecoder(this.messageConverters);
        }
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        RestResponse responseData;
        Object result = this.springDefaultDecode(response, type);
        String typeName = type.getTypeName();
        if (typeName.contains(RestResponse.class.getName()) && !"0".equals((responseData = (RestResponse)result).getResultCode())) {
            throw new BizException(responseData.getResultCode(), responseData.getResultMsg());
        }
        return result;
    }

    private Object springDefaultDecode(Response response, Type type) throws IOException {
        Object result = null;
        if (this.isParameterizeHttpEntity(type)) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            Object decodedObject = this.decoder.decode(response, type);
            result = this.createResponse(decodedObject, response);
        } else {
            result = this.isHttpEntity(type) ? this.createResponse(null, response) : this.decoder.decode(response, type);
        }
        return result;
    }

    private boolean isParameterizeHttpEntity(Type type) {
        return type instanceof ParameterizedType ? this.isHttpEntity(((ParameterizedType)type).getRawType()) : false;
    }

    private boolean isHttpEntity(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return HttpEntity.class.isAssignableFrom(c);
        }
        return false;
    }

    private <T> ResponseEntity<T> createResponse(Object instance, Response response) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        for (String key : response.headers().keySet()) {
            headers.put((Object)key, new LinkedList((Collection)response.headers().get(key)));
        }
        return new ResponseEntity(instance, (MultiValueMap)headers, HttpStatus.valueOf((int)response.status()));
    }
}

