/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.interceptor;

import com.wh.commons.annotations.ExportSqlIntercept;
import com.wh.commons.utils.ExportInfoServiceContextUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class AsynExportInterceptor
implements Interceptor {
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PLUGIN_FIELD_NAME = "h";
    public static final String PLUGIN_TARGET_FIELD_NAME = "target";
    public static final String MAPPED_STATEMENT_VALUE_NAME = "delegate.mappedStatement";
    public static final String BOUND_SQL_VALUE_NAME = "delegate.boundSql";
    public static final String BOUND_SQL_SQL_VALUE_NAME = "delegate.boundSql.sql";

    public Object intercept(Invocation invocation) throws Throwable {
        Object object;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaStatementHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        while (metaStatementHandler.hasGetter(PLUGIN_FIELD_NAME)) {
            object = metaStatementHandler.getValue(PLUGIN_FIELD_NAME);
            metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        }
        while (metaStatementHandler.hasGetter(PLUGIN_TARGET_FIELD_NAME)) {
            object = metaStatementHandler.getValue(PLUGIN_TARGET_FIELD_NAME);
            metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        }
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue(MAPPED_STATEMENT_VALUE_NAME);
        BoundSql boundSql = (BoundSql)metaStatementHandler.getValue(BOUND_SQL_VALUE_NAME);
        boolean flag = this.needExportSqlIntercept(mappedStatement);
        this.logger.info("daochulanjie-\u3010\u5bfc\u51fa\u62e6\u622a\u4fe1\u606f\u3011flag-{}-sql-{}", (Object)flag, (Object)boundSql.getSql());
        if (!flag) {
            return invocation.proceed();
        }
        Integer pageNumObj = ExportInfoServiceContextUtils.getPageNum();
        Integer pageSizeObj = ExportInfoServiceContextUtils.getPageSize();
        int pageNum = Math.max(Integer.parseInt(String.valueOf(pageNumObj)), 1);
        int pageSize = Math.max(Integer.parseInt(String.valueOf(pageSizeObj)), 10);
        int offset = (pageNum - 1) * pageSize;
        String pageSql = this.buildPageSql(boundSql.getSql(), offset, pageSize);
        metaStatementHandler.setValue(BOUND_SQL_SQL_VALUE_NAME, (Object)pageSql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        boolean mark;
        if (target instanceof StatementHandler && (mark = ExportInfoServiceContextUtils.getMark())) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private boolean needExportSqlIntercept(MappedStatement mappedStatement) throws ClassNotFoundException {
        Class<?> classType = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        String mName = mappedStatement.getId().substring(mappedStatement.getId().lastIndexOf(".") + 1);
        boolean flag = false;
        Method[] methodArray = classType.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ExportSqlIntercept.class) && mName.equals(method.getName())) {
                flag = true;
                break;
            }
            ++n2;
        }
        return flag;
    }

    public String buildPageSql(String sql, Integer pageNum, Integer pageSize) {
        return String.valueOf(sql) + " limit " + pageNum + "," + pageSize;
    }
}

