/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.log;

import com.dtyunxi.cube.framework.log.CubeAbstractApiLogAspect;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class WhAbstractApiLogAspect
extends CubeAbstractApiLogAspect {
    private static Logger logger = LoggerFactory.getLogger(WhAbstractApiLogAspect.class);
    @Value(value="#{'${logger.requestLog.denyList:}'.split(',')}")
    private List<String> LoggerApiDenyList;

    protected Object log(ProceedingJoinPoint point) throws Throwable {
        Object response;
        block11: {
            DateTime startTime = new DateTime();
            DateTime endTime = null;
            Interval interval = null;
            response = null;
            boolean showNull4req = (this.getDtoNullValueLogLevel() & 1) == 1;
            boolean showNull4resp = (this.getDtoNullValueLogLevel() & 2) == 2;
            String jsonStrFromReq = this.reqToString(point.getArgs(), showNull4req);
            String reqUrl = this.getReqUrl();
            try {
                if (!this.isDeny(reqUrl).booleanValue()) {
                    logger.info("url={}; Call API {}.{} Begin () Request => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq});
                }
                response = point.proceed();
                if (this.isDeny(reqUrl).booleanValue()) {
                    return response;
                }
            }
            catch (Exception var11) {
                endTime = new DateTime();
                interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
                logger.error("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Error => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), var11.getMessage()});
                logger.error("", (Throwable)var11);
                throw var11;
            }
            endTime = new DateTime();
            interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
            if (response instanceof RestResponse) {
                try {
                    RestResponse restResponse = (RestResponse)response;
                    if (logger.isDebugEnabled()) {
                        logger.debug("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.respToString(restResponse)});
                    }
                    if ("full".equals(this.getLogRespLevel())) {
                        logger.info("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.reqToString(response, showNull4resp)});
                        break block11;
                    }
                    if ("adjust".equals(this.getLogRespLevel())) {
                        logger.info("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.respToAdjustString(restResponse)});
                        break block11;
                    }
                    logger.info("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.respToString(restResponse)});
                }
                catch (Exception exception) {
                    logger.error("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.reqToString(response)});
                }
            } else {
                logger.info("url={}; Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", (Object)reqUrl, (Object)new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.objToString(response, showNull4resp)});
            }
        }
        return response;
    }

    private String getReqUrl() {
        HttpServletRequest request = null;
        String reqUrl = "";
        try {
            request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            logger.info("qingqiuxinxi-{}", (Object)request);
            logger.info("qingqiuxinxi-qingqiutou-{}", (Object)request.getHeader("batch.asyn.export.mark"));
            reqUrl = String.valueOf(request.getRequestURI());
        }
        catch (Exception e) {
            logger.info(String.valueOf(e.getMessage()) + "\u4e0d\u9700\u5904\u7406");
        }
        return reqUrl;
    }

    private Boolean isDeny(String reqUri) {
        if (!this.LoggerApiDenyList.isEmpty() && !reqUri.isEmpty() && this.LoggerApiDenyList.contains(reqUri)) {
            return true;
        }
        return false;
    }

    protected int getAdjustLenth() {
        return 8192;
    }

    public static void main(String[] args) {
        Object request = null;
        System.out.println(request != null ? String.valueOf(request.getRequestURL()) : "");
    }
}

