/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.mq;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.wh.commons.mq.MqPackageReqDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.MDC;

public abstract class IWhMqPackageMessageProcessor<T extends MqPackageReqDto<?>>
implements IMessageProcessor<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract MessageResponse executeProcess(T var1);

    public MessageResponse process(T message) {
        this.before(message);
        MessageResponse messageResponse = this.executeProcess(message);
        this.after(message, messageResponse);
        return messageResponse;
    }

    protected void before(T message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        ServiceContext.getContext().setAttachment("yes.req.userCode", StringUtils.isNotBlank((CharSequence)((MqPackageReqDto)message).getUserCode()) ? ((MqPackageReqDto)message).getUserCode() : "MQ");
        this.logger.info(String.format("className:%s", this.getClass().getName()));
    }

    protected void after(T message, MessageResponse messageResponse) {
        this.logger.info(String.format("className:%s end", this.getClass().getName()));
        ServiceContext.getContext().setAttachment("yes.req.userCode", null);
        MDC.remove((String)"yes.req.requestId");
        ServiceContext.getContext().removeAttachment("yes.req.requestId");
    }
}

