/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.sqlfilter;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.util.ParamConverter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.wh.commons.sqlfilter.SqlFilterRender;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFilterRenderHelper {
    private static final ThreadLocal<SqlFilterRender> LOCAL_RENDER_SQL_FILTER = new ThreadLocal();
    private static final Map<String, Map<String, Class<?>>> fieldClassMap = new ConcurrentHashMap();
    private static final String DEFAULT_MASTER_TABLE_NAME_ALIAS = "";
    private static final Integer DEFAULT_WHERE_INDEX = 1;
    public static final Logger logger = LoggerFactory.getLogger(SqlFilterRenderHelper.class);
    private static final String WHERE_KEY = "where";
    private static final String GROUP_BY_KEY = "group by";
    private static final String ORDER_BY_KEY = "order by";
    private static final String LIMIT_KEY = "limit";
    private static final DateTimeFormatter SDF_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter SDF_DATE_8 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static ThreadLocal<SimpleDateFormat> SDF_DATE_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };

    public static SqlFilterRender startRenderSqlFilter(String masterTableNameAlias, SqlFilter ... sqlFilters) {
        return SqlFilterRenderHelper.startRenderSqlFilter(masterTableNameAlias, DEFAULT_WHERE_INDEX, sqlFilters);
    }

    public static SqlFilterRender startRenderSqlFilter(SqlFilter ... sqlFilters) {
        return SqlFilterRenderHelper.startRenderSqlFilter(DEFAULT_MASTER_TABLE_NAME_ALIAS, DEFAULT_WHERE_INDEX, sqlFilters);
    }

    public static SqlFilterRender startRenderSqlFilter(List<SqlFilter> sqlFilters) {
        if (sqlFilters == null || sqlFilters.size() <= 0) {
            return new SqlFilterRender();
        }
        return SqlFilterRenderHelper.startRenderSqlFilter(DEFAULT_MASTER_TABLE_NAME_ALIAS, DEFAULT_WHERE_INDEX, sqlFilters.toArray(new SqlFilter[sqlFilters.size()]));
    }

    public static SqlFilterRender startRenderSqlFilter(String masterTableNameAlias, List<SqlFilter> sqlFilters) {
        if (CollUtil.isEmpty(sqlFilters)) {
            return new SqlFilterRender();
        }
        return SqlFilterRenderHelper.startRenderSqlFilter(masterTableNameAlias, DEFAULT_WHERE_INDEX, sqlFilters.toArray(new SqlFilter[sqlFilters.size()]));
    }

    public static SqlFilterRender startRenderSqlFilter(List<SqlFilter> sqlFilters, List<SqlOrderBy> sqlOrderBys) {
        if (sqlOrderBys != null && sqlOrderBys.size() > 0) {
            sqlOrderBys.forEach(o -> {
                if (StringUtils.isBlank((CharSequence)o.getProperty())) {
                    return;
                }
                o.setProperty(CamelToUnderline.camelToUnderline((String)o.getProperty()));
            });
        }
        if (sqlFilters == null || sqlFilters.size() <= 0) {
            return new SqlFilterRender();
        }
        return SqlFilterRenderHelper.startRenderSqlFilter(DEFAULT_MASTER_TABLE_NAME_ALIAS, DEFAULT_WHERE_INDEX, sqlFilters.toArray(new SqlFilter[sqlFilters.size()]));
    }

    public static SqlFilterRender startRenderSqlFilter(String masterTableNameAlias, Integer whereIndex, SqlFilter ... sqlFilters) {
        SqlFilterRender renderSqlFilter = new SqlFilterRender();
        renderSqlFilter.setMasterTableNameAlias(masterTableNameAlias);
        renderSqlFilter.setSqlFilters(Arrays.asList(sqlFilters));
        renderSqlFilter.setWhereIndex(whereIndex);
        LOCAL_RENDER_SQL_FILTER.set(renderSqlFilter);
        return renderSqlFilter;
    }

    public static void setNotSkipCount() {
        SqlFilterRender renderSqlFilter = LOCAL_RENDER_SQL_FILTER.get();
        if (renderSqlFilter == null) {
            return;
        }
        renderSqlFilter.setSkipCount(false);
    }

    public static SqlFilterRender getRenderSqlFilter() {
        return LOCAL_RENDER_SQL_FILTER.get();
    }

    public static void clearRenderSqlFilter() {
        LOCAL_RENDER_SQL_FILTER.remove();
    }

    public static String rebuildSql(String boundSql) {
        String sql = SqlFilterRenderHelper.buildRenderSqlFilterSql();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return boundSql;
        }
        boundSql = boundSql.toLowerCase();
        String whereBeforeSql = DEFAULT_MASTER_TABLE_NAME_ALIAS;
        String whereAfterSql = DEFAULT_MASTER_TABLE_NAME_ALIAS;
        if (boundSql.indexOf(WHERE_KEY) > 0) {
            int whereIndex = SqlFilterRenderHelper.getRenderSqlFilter().getWhereIndex();
            if (boundSql.toLowerCase().startsWith("select count") && SqlFilterRenderHelper.getRenderSqlFilter().getCountWhereIndex() != null) {
                whereIndex = SqlFilterRenderHelper.getRenderSqlFilter().getCountWhereIndex();
            }
            int whereKeyShowIndex = StringUtils.ordinalIndexOf((CharSequence)boundSql, (CharSequence)WHERE_KEY, (int)whereIndex);
            whereBeforeSql = boundSql.substring(0, whereKeyShowIndex);
            whereAfterSql = boundSql.substring(whereKeyShowIndex + WHERE_KEY.length(), boundSql.length());
            sql = String.format("%s %s %s and %s", whereBeforeSql, WHERE_KEY, sql, whereAfterSql);
        } else {
            if (boundSql.contains(GROUP_BY_KEY)) {
                whereBeforeSql = boundSql.substring(0, boundSql.indexOf(GROUP_BY_KEY));
                whereAfterSql = boundSql.substring(boundSql.indexOf(GROUP_BY_KEY), boundSql.length());
            } else if (boundSql.contains(ORDER_BY_KEY)) {
                whereBeforeSql = boundSql.substring(0, boundSql.indexOf(ORDER_BY_KEY));
                whereAfterSql = boundSql.substring(boundSql.indexOf(ORDER_BY_KEY), boundSql.length());
            } else if (boundSql.contains(LIMIT_KEY)) {
                whereBeforeSql = boundSql.substring(0, boundSql.indexOf(LIMIT_KEY));
                whereAfterSql = boundSql.substring(boundSql.indexOf(LIMIT_KEY), boundSql.length());
            } else {
                whereBeforeSql = boundSql;
            }
            sql = String.format("%s %s %s %s", whereBeforeSql, WHERE_KEY, sql, whereAfterSql);
        }
        return sql;
    }

    public static String buildRenderSqlFilterSql() {
        SqlFilterRender renderSqlFilter = SqlFilterRenderHelper.getRenderSqlFilter();
        if (renderSqlFilter == null) {
            return DEFAULT_MASTER_TABLE_NAME_ALIAS;
        }
        List<SqlFilter> sqlFilters = renderSqlFilter.getSqlFilters();
        if (CollectionUtils.isEmpty(sqlFilters)) {
            return DEFAULT_MASTER_TABLE_NAME_ALIAS;
        }
        Iterator<SqlFilter> var7 = sqlFilters.iterator();
        StringBuilder sb = new StringBuilder();
        while (var7.hasNext()) {
            String sqlFilterWhere;
            SqlFilter filter = var7.next();
            if (filter == null || StringUtils.isEmpty((CharSequence)filter.getProperty()) || !StringUtils.isNotBlank((CharSequence)(sqlFilterWhere = SqlFilterRenderHelper.getSqlFilterWhere(filter)))) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(sqlFilterWhere);
        }
        return sb.toString();
    }

    private static String getSqlFilterWhere(SqlFilter filter) {
        if (filter.getValue() == null || DEFAULT_MASTER_TABLE_NAME_ALIAS.equals(filter.getValue())) {
            switch (filter.getOperator()) {
                case isNull: 
                case isNotNull: {
                    break;
                }
                default: {
                    return DEFAULT_MASTER_TABLE_NAME_ALIAS;
                }
            }
        }
        StringBuilder sqlWhere = new StringBuilder();
        String ColumnName = PropertyNamingStrategy.SNAKE_CASE.nameForField(null, null, filter.getProperty());
        if (StringUtils.isEmpty((CharSequence)ColumnName)) {
            return DEFAULT_MASTER_TABLE_NAME_ALIAS;
        }
        if (SqlFilterRenderHelper.getRenderSqlFilter().getReplaceKeyMap().containsKey(filter.getProperty())) {
            sqlWhere.append(SqlFilterRenderHelper.getRenderSqlFilter().getReplaceKeyMap().get(filter.getProperty()));
        } else if (SqlFilterRenderHelper.getRenderSqlFilter().getReplaceKeyMap().containsKey(ColumnName)) {
            sqlWhere.append(SqlFilterRenderHelper.getRenderSqlFilter().getReplaceKeyMap().get(ColumnName));
        } else if (StringUtils.isEmpty((CharSequence)SqlFilterRenderHelper.getRenderSqlFilter().getMasterTableNameAlias())) {
            sqlWhere.append(ColumnName);
        } else {
            sqlWhere.append(String.format("%s.%s", SqlFilterRenderHelper.getRenderSqlFilter().getMasterTableNameAlias(), ColumnName));
        }
        switch (filter.getOperator()) {
            case isNull: {
                sqlWhere.append(" is null");
                break;
            }
            case isNotNull: {
                sqlWhere.append(" is not null");
                break;
            }
            case eq: {
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append(" = '").append(value).append("'");
                    break;
                }
                sqlWhere.append(" = ").append(filter.getValue());
                break;
            }
            case ne: {
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append(" <> '").append(value).append("'");
                    break;
                }
                sqlWhere.append(" <> ").append(filter.getValue());
                break;
            }
            case gt: 
            case lt: {
                if (filter.getOperator() == SqlFilter.Operator.gt) {
                    sqlWhere.append(" > ");
                } else {
                    sqlWhere.append(" < ");
                }
                if (filter.getValue() instanceof Date) {
                    sqlWhere.append("'").append(SDF_DATE_THREAD_LOCAL.get().format(filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof LocalDate) {
                    sqlWhere.append("'").append(SDF_DATE_8.format((LocalDate)filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof LocalDateTime) {
                    sqlWhere.append("'").append(SDF_DATETIME.format((LocalDateTime)filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append("'").append(value).append("'");
                    break;
                }
                sqlWhere.append(filter.getValue());
                break;
            }
            case ge: 
            case le: {
                String value = " 00:00:01'";
                if (filter.getOperator() == SqlFilter.Operator.ge) {
                    sqlWhere.append(" >= ");
                } else {
                    sqlWhere.append(" <= ");
                    value = " 23:59:59'";
                }
                if (filter.getValue() instanceof Date) {
                    sqlWhere.append("'").append(SDF_DATE_THREAD_LOCAL.get().format(filter.getValue())).append(value);
                    break;
                }
                if (filter.getValue() instanceof LocalDate) {
                    sqlWhere.append("'").append(SDF_DATE_8.format((LocalDate)filter.getValue())).append(value);
                    break;
                }
                if (filter.getValue() instanceof LocalDateTime) {
                    sqlWhere.append("'").append(SDF_DATETIME.format((LocalDateTime)filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof String) {
                    value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append("'").append(value).append("'");
                    break;
                }
                sqlWhere.append(filter.getValue());
                break;
            }
            case like: {
                String value = SqlFilterRenderHelper.likeValue(filter.getValue().toString());
                sqlWhere.append(" like '").append(value.replaceAll("'", "''")).append("'");
                break;
            }
            case in: {
                String filterValue = SqlFilterRenderHelper.processOperatorInValue(filter);
                if (!StringUtils.isNotBlank((CharSequence)filterValue)) {
                    return DEFAULT_MASTER_TABLE_NAME_ALIAS;
                }
                sqlWhere.append(" in (").append(filterValue).append(")");
            }
        }
        return sqlWhere.toString();
    }

    private static String likeValue(String value) {
        String v;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int start = 0;
        int end = value.length();
        String startValue = DEFAULT_MASTER_TABLE_NAME_ALIAS;
        String endValue = DEFAULT_MASTER_TABLE_NAME_ALIAS;
        if ("%".equals(value.substring(0, 1))) {
            start = 1;
            startValue = "%";
        }
        if ("%".equals(value.substring(value.length() - 1, value.length()))) {
            end = value.length() - 1;
            endValue = "%";
        }
        return (v = value.substring(start, end)).contains("%") ? String.valueOf(startValue) + v.replaceAll("%", "[%]") + endValue : "%" + value + "%";
    }

    private static String processOperatorInValue(SqlFilter filter) {
        if (filter == null || filter.getValue() == null) {
            return null;
        }
        Class<Object> fieldClass = null;
        SqlFilterRender sqlFilterRender = SqlFilterRenderHelper.getRenderSqlFilter();
        String columnName = PropertyNamingStrategy.SNAKE_CASE.nameForField(null, null, filter.getProperty());
        if (sqlFilterRender.getReplaceKeyClassMap().containsKey(filter.getProperty())) {
            fieldClass = sqlFilterRender.getReplaceKeyClassMap().get(filter.getProperty());
        } else if (sqlFilterRender.getReplaceKeyClassMap().containsKey(columnName)) {
            fieldClass = sqlFilterRender.getReplaceKeyClassMap().get(columnName);
        } else if (sqlFilterRender.getFilterObjClass() != null) {
            fieldClass = SqlFilterRenderHelper.getFieldClass(sqlFilterRender.getFilterObjClass(), filter.getProperty());
        }
        if (fieldClass == null) {
            fieldClass = String.class;
        }
        ArrayList processedValues = Lists.newArrayList();
        try {
            if (!String.class.equals(fieldClass)) {
                if (filter.getValue() instanceof Collection) {
                    return Joiner.on((String)",").skipNulls().join((Iterable)((Collection)filter.getValue()));
                }
                if (filter.getValue().getClass().isArray()) {
                    Object[] objs = ParamConverter.objectToArray((Object)filter.getValue());
                    return Joiner.on((String)",").skipNulls().join(objs);
                }
                return filter.getValue().toString();
            }
            Object filterValue = filter.getValue();
            if (filterValue instanceof String) {
                String[] splitValues;
                String[] stringArray = splitValues = ((String)filterValue).split(",");
                int n = splitValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    String splitValue = value;
                    if (!splitValue.startsWith("'")) {
                        splitValue = "'" + splitValue;
                    }
                    if (!splitValue.endsWith("'")) {
                        splitValue = String.valueOf(splitValue) + "'";
                    }
                    processedValues.add(splitValue);
                    ++n2;
                }
            } else if (filterValue instanceof Collection) {
                Collection listFilterValues = (Collection)filterValue;
                for (Object listValue : listFilterValues) {
                    if (listValue == null) continue;
                    if (listValue instanceof String) {
                        String processValue = (String)listValue;
                        if (!processValue.startsWith("'")) {
                            processValue = "'" + processValue;
                        }
                        if (!processValue.endsWith("'")) {
                            processValue = String.valueOf(processValue) + "'";
                        }
                        processedValues.add(processValue);
                        continue;
                    }
                    processedValues.add("'" + listValue + "'");
                }
            } else {
                processedValues.add("'" + filterValue + "'");
            }
            return Joiner.on((String)",").skipNulls().join((Iterable)processedValues);
        }
        catch (Exception var9) {
            logger.error("sqlFilter\u4f20\u5165\u7684property\u6709\u8bef", (Throwable)var9);
            return null;
        }
    }

    private static Class<?> getFieldClass(Class<?> respClass, String property) {
        String respClassName = respClass.getName();
        if (fieldClassMap.get(respClassName) != null && fieldClassMap.get(respClassName).get(property) != null) {
            return fieldClassMap.get(respClassName).get(property);
        }
        fieldClassMap.putIfAbsent(respClassName, new ConcurrentHashMap());
        try {
            Class<?> propertyClass = respClass.getDeclaredField(property).getType();
            logger.info("sqlFilter\u4f20\u5165\u7684property[{}]\uff0cclass={}", (Object)property, propertyClass);
            fieldClassMap.get(respClassName).put(property, propertyClass);
            return propertyClass;
        }
        catch (NoSuchFieldException e) {
            logger.error("sqlFilter\u4f20\u5165\u7684property\u4e0erespClass\u4e0d\u5339\u914d", (Throwable)e);
            return String.class;
        }
    }
}

