/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.sqlfilter;

import com.wh.commons.sqlfilter.SqlFilterMethod;
import com.wh.commons.sqlfilter.SqlFilterRender;
import com.wh.commons.sqlfilter.SqlFilterRenderHelper;
import com.wh.commons.sqlfilter.WhMybatisPrepare;
import java.sql.Connection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class SqlFilterRenderInterceptor
implements Interceptor,
WhMybatisPrepare {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BOUND_SQL_SQL_VALUE_NAME = "delegate.boundSql.sql";
    private SqlFilterMethod sqlFilterMethod;

    public SqlFilterRenderInterceptor(SqlFilterMethod sqlFilterMethod) {
        this.sqlFilterMethod = sqlFilterMethod;
    }

    private SqlFilterRenderInterceptor() {
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object proceed;
        String sql = null;
        try {
            try {
                MetaObject metaObject = this.getMetaObject(invocation);
                BoundSql boundSql = this.getBoundSql(metaObject);
                sql = boundSql.getSql();
                metaObject.setValue(BOUND_SQL_SQL_VALUE_NAME, (Object)this.sqlFilterMethod.rebuildSql(sql));
                proceed = invocation.proceed();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                proceed = invocation.proceed();
                if (StringUtils.isNotEmpty((CharSequence)sql) && !sql.toLowerCase().startsWith("select count")) {
                    SqlFilterRenderHelper.clearRenderSqlFilter();
                } else if (!SqlFilterRenderHelper.getRenderSqlFilter().isSkipCount()) {
                    SqlFilterRenderHelper.clearRenderSqlFilter();
                }
            }
        }
        finally {
            if (StringUtils.isNotEmpty((CharSequence)sql) && !sql.toLowerCase().startsWith("select count")) {
                SqlFilterRenderHelper.clearRenderSqlFilter();
            } else if (!SqlFilterRenderHelper.getRenderSqlFilter().isSkipCount()) {
                SqlFilterRenderHelper.clearRenderSqlFilter();
            }
        }
        return proceed;
    }

    public Object plugin(Object target) {
        SqlFilterRender renderSqlFilter;
        if (target instanceof StatementHandler && (renderSqlFilter = SqlFilterRenderHelper.getRenderSqlFilter()) != null) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

