/*
 * Decompiled with CFR 0.152.
 */
package com.wh.commons.utils;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.util.ReflectionUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.Validation;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AssertUtil {
    private static Logger logger = LoggerFactory.getLogger(AssertUtil.class);

    public static void isTrue(boolean expression, String message) {
        AssertUtil.isTrue(expression, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isFalse(boolean expression, String message) {
        AssertUtil.isTrue(!expression, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isTrue(boolean expression, String code, String message) {
        if (!expression) {
            throw new BizException(code, message);
        }
    }

    public static void isTrueByObject(Object o, String message) {
        AssertUtil.isTrueByObject(o, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isTrueByObject(Object o, String code, String message) {
        if (o != null) {
            if (o instanceof String ? StringUtils.isBlank((CharSequence)((String)o)) : o instanceof Collection && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((List)o))) {
                throw new BizException(code, message);
            }
        } else {
            throw new BizException(code, message);
        }
    }

    public static void isNotEmpty(String param, String paramName) {
        String notifyMessage = String.format("\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", paramName);
        AssertUtil.isFalse(StringUtils.isEmpty((CharSequence)param), notifyMessage);
    }

    public static void isNotNull(Object param, String paramName) {
        String notifyMessage = String.format("\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", paramName);
        AssertUtil.isFalse(param == null, notifyMessage);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, String errorMsg) {
        if (!MapUtils.isEmpty(map)) {
            throw new BizException(ExceptionCode.FAIL.getCode(), errorMsg);
        }
        return map;
    }

    public static <K, V> Map<K, V> isEmpty(Map<K, V> map, String errorMsg) {
        if (MapUtils.isEmpty(map)) {
            throw new BizException(ExceptionCode.FAIL.getCode(), errorMsg);
        }
        return map;
    }

    public static <T> Collection<T> isNotEmpty(Collection<T> collection, String errorMsg) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(collection)) {
            throw new BizException(ExceptionCode.FAIL.getCode(), errorMsg);
        }
        return collection;
    }

    public static <K, V> Map<K, List<V>> isMapEmpty(Map<K, List<V>> map, String errorMsg) {
        if (MapUtils.isEmpty(map)) {
            throw new BizException(ExceptionCode.FAIL.getCode(), errorMsg);
        }
        return map;
    }

    public static <T> T isNull(T object, String errorMsg) {
        if (object == null) {
            throw new BizException(ExceptionCode.FAIL.getCode(), errorMsg);
        }
        return object;
    }

    public static void emptyValidated(Object obj, String ... fields) {
        AssertUtil.isTrue(obj != null, ExceptionCode.INVALID_PARAM.getCode(), ExceptionCode.INVALID_PARAM.getMsg());
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            Object fieldValue = ReflectionUtils.getFieldValue((Object)obj, (String)field);
            boolean expression = true;
            boolean bl = expression = fieldValue != null;
            if (expression) {
                if (fieldValue instanceof String) {
                    expression = StringUtils.isNotBlank((CharSequence)((String)fieldValue));
                } else if (fieldValue instanceof Short) {
                    expression = (Short)fieldValue > 0;
                } else if (fieldValue instanceof Integer) {
                    expression = (Integer)fieldValue > 0;
                } else if (fieldValue instanceof Long) {
                    expression = (Long)fieldValue > 0L;
                } else if (fieldValue instanceof Float) {
                    expression = ((Float)fieldValue).floatValue() > 0.0f;
                } else if (fieldValue instanceof Double) {
                    expression = (Double)fieldValue > 0.0;
                } else if (fieldValue instanceof BigDecimal) {
                    expression = ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) > 0;
                } else if (fieldValue instanceof Collection) {
                    expression = !CollectionUtils.isEmpty((Collection)((Collection)fieldValue));
                } else if (fieldValue instanceof Map) {
                    expression = !CollectionUtils.isEmpty((Map)((Map)fieldValue));
                }
            }
            AssertUtil.isTrue(expression, ExceptionCode.INVALID_PARAM.getCode(), String.valueOf(field) + ExceptionCode.INVALID_PARAM.getMsg());
            ++n2;
        }
    }

    public static void assertMaxLength(String s, int maxLength, String errorMessage) {
        if (s != null && s.length() > maxLength) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertHHmm(String str, String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef[HH:mm]";
        }
        if (str == null) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
        if (!Pattern.matches("^(20|21|22|23|[0-1]\\d):[0-5]\\d$", str)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static <T> T catchIndexException(List<T> list, Boolean flag) {
        try {
            T t = list.get(0);
            AssertUtil.isTrue(ObjectUtil.isNotNull(t), "\u7a7a\u5bf9\u8c61");
            return t;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5f02\u5e38-{} {}", (Object)e, (Object)e.getMessage());
            if (Objects.isNull(flag) || flag.booleanValue()) {
                throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u5931\u8d25-" + e + e.getMessage());
            }
            return null;
        }
    }

    public static void notNull(Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new BizException(AssertUtil.nullSafeGet(messageSupplier));
        }
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void validation(@Valid Object param, Class<?> ... groupClz) {
        @Valid Set validateSet = Validation.buildDefaultValidatorFactory().getValidator().validate(param, (Class[])groupClz);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)validateSet)) {
            String messages = validateSet.stream().map(ConstraintViolation::getMessage).reduce((m1, m2) -> String.valueOf(m1) + "\uff1b" + m2).orElse("\u53c2\u6570\u8f93\u5165\u6709\u8bef\uff01");
            throw new BizException(messages);
        }
    }
}

